/*
 * Decompiled with CFR 0.152.
 */
package cn.gudqs.business.common.api;

import cn.gudqs.base.BaseController;
import cn.gudqs.base.MapBean;
import cn.gudqs.base.ResultBean;
import cn.gudqs.business.common.entity.SysDictionaryModel;
import cn.gudqs.business.common.service.ISysDictionaryService;
import cn.gudqs.helper.DictionaryUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/sys/dictionary"})
@Api(description="\u5b57\u5178\u67e5\u8be2")
public class SysDictionaryApiController
extends BaseController {
    @Resource
    private ISysDictionaryService sysDictionaryService;

    @ApiOperation(value="\u6839\u636e parent code \u67e5\u8be2\u5b57\u5178\u6570\u636e")
    @PostMapping(value={"/findAll"})
    public ResultBean<List<SysDictionaryModel>> findAll(String parentCode) {
        SysDictionaryApiController.require((parentCode != null ? 1 : 0) != 0, (String)"parentCode \u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return this.success(DictionaryUtil.findByParentCode(parentCode));
    }

    @ApiOperation(value="\u6839\u636e code \u67e5\u8be2\u5b57\u5178\u4fe1\u606f")
    @PostMapping(value={"/findByCode"})
    public ResultBean<SysDictionaryModel> findByCode(String code) {
        SysDictionaryApiController.require((code != null ? 1 : 0) != 0, (String)"code \u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return this.success(DictionaryUtil.findByCode(code));
    }

    @ApiOperation(value="\u6839\u636e parentCodes \u6570\u7ec4\u67e5\u8be2\u5b57\u5178\u6570\u636e")
    @PostMapping(value={"/findByCodes"})
    public ResultBean<MapBean> findByCodes(@RequestBody String[] parentCodes) {
        SysDictionaryApiController.require((parentCodes != null && parentCodes.length > 0 ? 1 : 0) != 0, (String)"parentCodes \u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        MapBean codeMap = new MapBean();
        for (String parentCode : parentCodes) {
            List<SysDictionaryModel> dictionaryModels = DictionaryUtil.findByParentCode(parentCode);
            codeMap.put((Object)parentCode, dictionaryModels);
        }
        return this.success(codeMap);
    }
}

