/*
 * Decompiled with CFR 0.152.
 */
package cn.granitech.variantorm.metadata.fieldtype;

import cn.granitech.variantorm.exception.DataAccessException;
import cn.granitech.variantorm.metadata.impl.ActualField;
import cn.granitech.variantorm.persistence.PersistenceManager;
import cn.granitech.variantorm.persistence.license.LicenseInfo;
import cn.granitech.variantorm.pojo.Field;
import cn.granitech.variantorm.util.MDHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;

public class IntegerField
extends ActualField {
    @Override
    public String getName() {
        return "Integer";
    }

    @Override
    public void setParamValue(PreparedStatement pstmt, int index, Object value, PersistenceManager pm, Field paramField) {
        block3: {
            if (value != null) break block3;
            pstmt.setNull(index, 4);
            return;
        }
        try {
            pstmt.setInt(index, (Integer)value);
            return;
        }
        catch (ClassCastException | SQLException a2) {
            System.err.println(new StringBuilder().insert(0, LicenseInfo.ALLATORIxDEMO("o\u001fL\u001aMVG\u0017D\u0013\t\u0019OVY\u0017[\u0017D\u0013]\u0013[L\t")).append(paramField.getName()).toString());
            throw new DataAccessException(MDHelper.ALLATORIxDEMO("5j\u0012/\u000fa\u0012j\u0001j\u0014/\u0012`F_\u0014j\u0016n\u0014j\u0002\\\u0012n\u0012j\u000bj\b{Fj\u0014}\t}"), a2);
        }
    }

    @Override
    public Object fromJson(Object jsonValue) {
        if (jsonValue == null) {
            return null;
        }
        if (jsonValue instanceof BigDecimal) {
            return ((BigDecimal)jsonValue).setScale(0, RoundingMode.HALF_UP).intValue();
        }
        if (jsonValue instanceof Long) {
            return ((Long)jsonValue).intValue();
        }
        if (jsonValue instanceof String) {
            if (StringUtils.isBlank((CharSequence)((String)jsonValue))) {
                return null;
            }
            return new Integer(((String)jsonValue).replaceAll(",", ""));
        }
        if (jsonValue instanceof Integer) {
            return (Integer)jsonValue;
        }
        throw new IllegalArgumentException(new StringBuilder().insert(0, LicenseInfo.ALLATORIxDEMO("\u001fG\u0000H\u001a@\u0012\t\u0012H\u0002HVO\u0019[\u001bH\u0002\u0013Vr")).append(jsonValue).append("]").toString());
    }

    public IntegerField() {
        super(Integer.class);
    }

    @Override
    public Object readDBValue(PersistenceManager pm, Field field, ResultSet rs, int index) {
        int a2;
        block3: {
            try {
                ResultSet resultSet = rs;
                a2 = resultSet.getInt(index);
                if (!resultSet.wasNull()) break block3;
                return null;
            }
            catch (SQLException a3) {
                throw new DataAccessException(MDHelper.ALLATORIxDEMO("!j\u0012/\u000fa\u0012j\u0001j\u0014/\u0000}\tbF]\u0003|\u0013c\u0012\\\u0003{Fj\u0014}\t}"), a3);
            }
        }
        return a2;
    }
}

