/*
 * Decompiled with CFR 0.152.
 */
package cn.granitech.variantorm.persistence.license;

import cn.granitech.variantorm.exception.LicenseException;
import cn.granitech.variantorm.persistence.license.LicenseAccount;
import cn.granitech.variantorm.persistence.license.LicenseInfo;
import cn.granitech.variantorm.persistence.license.OfflineLicenseHelper;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

public class LicenseHelper
implements Serializable {
    private static final long serialVersionUID = -1L;
    private static final String META_LICENSE_URL = "http://license.melecode.com:8080/license/checkAccountInfo";
    private static final int FREE_VERSION_ENTITY_LIMIT = 30;
    private static final String USER_LICENSE_PATH = System.getProperty("user.home");

    public static void main(String[] args) {
        LicenseHelper.getLicense("Test\u9879\u76ee\u540d", "10002", "9eiDVKPuzOpaCpteJSYiZz01D3E59Qw2OCXxc54v", "080408b8cf7e4e5db5896ad2cf021559", 8302, null);
    }

    public static LicenseInfo getLicense(String projectName, String account, String secretKey, String licenseCode, Integer port, String offlineLicense) {
        String deviceNo;
        long timestamp = System.currentTimeMillis();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("account", account);
        paramMap.put("licenseCode", licenseCode);
        paramMap.put("port", port);
        paramMap.put("timestamp", timestamp);
        Boolean tenantSwitch = false;
        try {
            deviceNo = LicenseHelper.readLicenseFile(port);
        }
        catch (Exception e) {
            e.printStackTrace();
            return LicenseInfo.buildFreeLicense("\u8bbe\u5907\u7801\u83b7\u53d6\u5931\u8d25");
        }
        try {
            String deviceInfo = String.format("\u9879\u76ee\u540d\u79f0: %s,\u7aef\u53e3: %d", projectName, port);
            if ((StringUtils.isBlank((CharSequence)account) || StringUtils.isBlank((CharSequence)secretKey) || StringUtils.isBlank((CharSequence)licenseCode)) && StringUtils.isBlank((CharSequence)offlineLicense)) {
                return LicenseInfo.buildFreeLicense(deviceNo);
            }
            if (StringUtils.isNotBlank((CharSequence)offlineLicense)) {
                Map<String, Object> licenseMap = OfflineLicenseHelper.decryptData(offlineLicense);
                LicenseAccount licenseAccount = new LicenseAccount(account, port, licenseCode, deviceNo, timestamp, deviceInfo);
                if (!licenseAccount.checkOfflineSign((String)licenseMap.get("secretKey"), (String)licenseMap.get("offlineSign"))) {
                    LicenseException licenseException = new LicenseException("\u79bb\u7ebf\u6388\u6743\u8bbe\u5907\u4e0d\u5339\u914d\uff01");
                    licenseException.setDeviceNo(deviceNo);
                    throw licenseException;
                }
                if (licenseMap.containsKey("tenantSwitch")) {
                    tenantSwitch = (Boolean)licenseMap.get("tenantSwitch");
                }
                return LicenseInfo.buildCommercialLicense((String)licenseMap.get("licenseCode"), (String)licenseMap.get("companyName"), (String)licenseMap.get("account"), (String)licenseMap.get("version"), (Integer)licenseMap.get("entityLimit"), deviceNo, tenantSwitch);
            }
            paramMap.put("deviceNo", deviceNo);
            paramMap.put("deviceInfo", deviceInfo);
            LicenseAccount licenseAccount = new LicenseAccount(account, port, licenseCode, deviceNo, timestamp, deviceInfo);
            paramMap.put("sign", licenseAccount.getClientSign(secretKey));
            HttpRequest post = HttpUtil.createPost((String)META_LICENSE_URL);
            post.setConnectionTimeout(10000);
            post.body(JSON.toJSONString(paramMap));
            String body = post.execute().body();
            JSONObject result = JSON.parseObject((String)body);
            if (result.getIntValue("code") != 200) {
                System.out.println(result.getString("error"));
                throw new LicenseException(result.getString("error"));
            }
            JSONObject data = result.getJSONObject("data");
            if (StringUtils.isBlank((CharSequence)data.getString("serverSign")) || !data.getString("serverSign").equals(licenseAccount.getSeverSign(secretKey))) {
                System.out.println("\u5b89\u5168\u6821\u9a8c\u5f02\u5e38\uff01\uff01\uff01");
                throw new LicenseException("\u5b89\u5168\u6821\u9a8c\u5f02\u5e38\uff01");
            }
            tenantSwitch = data.containsKey("tenantSwitch") && data.getBoolean("tenantSwitch") != false;
            return LicenseInfo.buildCommercialLicense(licenseCode, data.getString("companyName"), data.getString("account"), data.getString("version"), data.getInteger("entityLimit"), deviceNo, tenantSwitch);
        }
        catch (Exception e) {
            e.printStackTrace();
            return LicenseInfo.buildFreeLicense(deviceNo);
        }
    }

    private static void printlnLicense(String companyName, String version, String account, Integer entityLimit) {
        System.out.println("*****************************************************");
        System.out.println(companyName);
        System.out.println("\u7248\u672c\uff1a" + version);
        System.out.println("\u8d26\u53f7\uff1a" + account);
        System.out.println("\u5b9e\u4f53\u6570\u4e0a\u9650\uff1a" + (entityLimit == null ? "\u65e0\u9650\u5236" : entityLimit));
        System.out.println("*****************************************************");
    }

    private static String createLicenseFile(int port) {
        String content;
        File licenseFolder = new File(USER_LICENSE_PATH, ".license");
        File licenseFile = new File(licenseFolder, LicenseHelper.getPortMd5(port));
        try {
            Files.createDirectories(licenseFolder.toPath(), new FileAttribute[0]);
            content = "DN_" + RandomUtil.randomString((int)35);
            Files.write(licenseFile.toPath(), content.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            throw new LicenseException("\u5199\u5165\u8bb8\u53ef\u6587\u4ef6\u5931\u8d25", e);
        }
        return content;
    }

    private static String readLicenseFile(int port) {
        File licenseFolder = new File(USER_LICENSE_PATH, ".license");
        File licenseFile = new File(licenseFolder, LicenseHelper.getPortMd5(port));
        String fileContent = "";
        try {
            if (!licenseFile.exists()) {
                return LicenseHelper.createLicenseFile(port);
            }
            List<String> lines = Files.readAllLines(licenseFile.toPath());
            fileContent = String.join((CharSequence)"\n", lines);
        }
        catch (IOException e) {
            throw new LicenseException("\u8bfb\u53d6\u8bb8\u53ef\u6587\u4ef6\u5931\u8d25", e);
        }
        return fileContent;
    }

    private static String getPortMd5(int port) {
        return DigestUtils.md5Hex((String)("Meta!_License&*" + port));
    }
}

