/*
 * Decompiled with CFR 0.152.
 */
package cn.granitech.variantorm.persistence.license;

import cn.granitech.variantorm.util.MD5Helper;
import java.io.Serializable;

public class LicenseAccount
implements Serializable {
    private static final long serialVersionUID = -1L;
    private String account;
    private Integer port;
    private String licenseCode;
    private String deviceNo;
    private Long timestamp;
    private String sign;
    private String deviceInfo;
    private static final String SALT = "metaCode_js";

    public LicenseAccount() {
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getLicenseCode() {
        return this.licenseCode;
    }

    public void setLicenseCode(String licenseCode) {
        this.licenseCode = licenseCode;
    }

    public String getDeviceNo() {
        return this.deviceNo;
    }

    public void setDeviceNo(String deviceNo) {
        this.deviceNo = deviceNo;
    }

    public String getSign() {
        return this.sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getDeviceInfo() {
        return this.deviceInfo;
    }

    public void setDeviceInfo(String deviceInfo) {
        this.deviceInfo = deviceInfo;
    }

    public LicenseAccount(String account, Integer port, String licenseCode, String deviceNo, Long timestamp, String deviceInfo) {
        this.account = account;
        this.port = port;
        this.licenseCode = licenseCode;
        this.deviceNo = deviceNo;
        this.timestamp = timestamp;
        this.deviceInfo = deviceInfo;
    }

    public String getClientSign(String secretKey) {
        StringBuilder sign = new StringBuilder();
        sign.append(this.account);
        sign.append(secretKey);
        sign.append(this.port);
        sign.append(this.deviceNo);
        sign.append(this.timestamp);
        return MD5Helper.md5HexForSalt(sign.toString(), SALT);
    }

    public String getSeverSign(String secretKey) {
        StringBuilder sign = new StringBuilder();
        sign.append(this.timestamp);
        sign.append(this.deviceNo);
        sign.append(this.port);
        sign.append(this.account);
        sign.append(secretKey);
        return MD5Helper.md5HexForSalt(sign.toString(), SALT);
    }

    public static String getOfflineSign(String secretKey, String offlineDeviceCode) {
        StringBuilder offlineSign = new StringBuilder();
        offlineSign.append(offlineDeviceCode);
        offlineSign.append("OfflineSign");
        offlineSign.append(secretKey);
        return MD5Helper.md5HexForSalt(offlineSign.toString(), SALT);
    }

    public boolean checkOfflineSign(String secretKey, String offlineSign) {
        return offlineSign.equals(LicenseAccount.getOfflineSign(secretKey, this.deviceNo));
    }
}

