/*
 * Decompiled with CFR 0.152.
 */
package cn.granitech.variantorm.metadata.fieldtype;

import cn.granitech.variantorm.exception.DataAccessException;
import cn.granitech.variantorm.exception.IllegalFieldValueException;
import cn.granitech.variantorm.exception.LicenseException;
import cn.granitech.variantorm.metadata.impl.ActualField;
import cn.granitech.variantorm.persistence.PersistenceManager;
import cn.granitech.variantorm.pojo.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DecimalField
extends ActualField {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object readDBValue(PersistenceManager pm, Field field, ResultSet rs, int index) {
        try {
            ResultSet resultSet = rs;
            BigDecimal a = resultSet.getBigDecimal(index);
            if (resultSet.wasNull()) {
                return null;
            }
            int a2 = field.getFieldViewModel() == null || field.getFieldViewModel().getPrecision() == null ? 2 : field.getFieldViewModel().getPrecision();
            return a.setScale(a2, RoundingMode.HALF_UP);
        }
        catch (SQLException a) {
            throw new DataAccessException(LicenseException.ALLATORIxDEMO("\u0010\u0003#F3\u00034\u000f:\u0007;F1\u00148\u000bw42\u0015\"\n#52\u0012w\u0003%\u00148\u0014"), a);
        }
    }

    public DecimalField() {
        super(BigDecimal.class);
    }

    @Override
    public void setParamValue(PreparedStatement pstmt, int index, Object value, PersistenceManager pm) {
        block3: {
            try {
                if (value != null) break block3;
                pstmt.setNull(index, 3);
                return;
            }
            catch (SQLException a) {
                throw new DataAccessException(IllegalFieldValueException.ALLATORIxDEMO("\u001a)=l-)*%$-%l=#i\u001c;)9-;)-\u001f=-=)$)'8i);>&>"), a);
            }
        }
        pstmt.setBigDecimal(index, (BigDecimal)value);
    }

    @Override
    public Object fromJson(Object jsonValue) {
        if (jsonValue == null) {
            return null;
        }
        if (jsonValue instanceof BigDecimal) {
            return jsonValue;
        }
        if (jsonValue instanceof Long) {
            return BigDecimal.valueOf((Long)jsonValue);
        }
        if (jsonValue instanceof Integer) {
            return new BigDecimal((Integer)jsonValue);
        }
        if (jsonValue instanceof String) {
            return new BigDecimal(((String)jsonValue).replaceAll(",", ""));
        }
        if (jsonValue instanceof Double) {
            return BigDecimal.valueOf((Double)jsonValue);
        }
        throw new IllegalArgumentException(new StringBuilder().insert(0, IllegalFieldValueException.ALLATORIxDEMO(" \"?-%%-l--=-i*&>$-=vi\u0017")).append(jsonValue).append("]").toString());
    }

    @Override
    public String getName() {
        return "Decimal";
    }
}

