/*
 * Decompiled with CFR 0.152.
 */
package cn.granitech.variantorm.metadata.fieldtype;

import cn.granitech.variantorm.exception.DataAccessException;
import cn.granitech.variantorm.exception.DuplicatedEntityException;
import cn.granitech.variantorm.metadata.impl.ActualField;
import cn.granitech.variantorm.persistence.PersistenceManager;
import cn.granitech.variantorm.persistence.license.OfflineLicenseHelper;
import cn.granitech.variantorm.pojo.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;

public class IntegerField
extends ActualField {
    @Override
    public Object fromJson(Object jsonValue) {
        if (jsonValue == null) {
            return null;
        }
        if (jsonValue instanceof BigDecimal) {
            return ((BigDecimal)jsonValue).setScale(0, RoundingMode.HALF_UP).intValue();
        }
        if (jsonValue instanceof Long) {
            return ((Long)jsonValue).intValue();
        }
        if (jsonValue instanceof String) {
            if (StringUtils.isBlank((CharSequence)((String)jsonValue))) {
                return null;
            }
            return new Integer(((String)jsonValue).replaceAll(",", ""));
        }
        if (jsonValue instanceof Integer) {
            return (Integer)jsonValue;
        }
        throw new IllegalArgumentException(new StringBuilder().insert(0, DuplicatedEntityException.ALLATORIxDEMO("A\u0016^\u0019D\u0011LXL\u0019\\\u0019\b\u001eG\nE\u0019\\B\b#")).append(jsonValue).append("]").toString());
    }

    @Override
    public void setParamValue(PreparedStatement pstmt, int index, Object value, PersistenceManager pm) {
        block3: {
            try {
                if (value != null) break block3;
                pstmt.setNull(index, 4);
                return;
            }
            catch (SQLException a2) {
                throw new DataAccessException(DuplicatedEntityException.ALLATORIxDEMO("{\u001d\\XA\u0016\\\u001dO\u001dZX\\\u0017\b(Z\u001dX\u0019Z\u001dL+\\\u0019\\\u001dE\u001dF\f\b\u001dZ\nG\n"), a2);
            }
        }
        pstmt.setInt(index, (Integer)value);
    }

    @Override
    public String getName() {
        return "Integer";
    }

    public IntegerField() {
        super(Integer.class);
    }

    @Override
    public Object readDBValue(PersistenceManager pm, Field field, ResultSet rs, int index) {
        int a2;
        block3: {
            try {
                ResultSet resultSet = rs;
                a2 = resultSet.getInt(index);
                if (!resultSet.wasNull()) break block3;
                return null;
            }
            catch (SQLException a3) {
                throw new DataAccessException(OfflineLicenseHelper.ALLATORIxDEMO("\u000e)=l \"=).);l/>&!i\u001e,?< =\u001f,8i);>&>"), a3);
            }
        }
        return a2;
    }
}

