/*
 * Decompiled with CFR 0.152.
 */
package cn.granitech.variantorm.metadata.fieldtype;

import cn.granitech.variantorm.exception.DataAccessException;
import cn.granitech.variantorm.exception.InvalidEntityException;
import cn.granitech.variantorm.exception.NullFieldValueException;
import cn.granitech.variantorm.metadata.impl.ActualField;
import cn.granitech.variantorm.persistence.PersistenceManager;
import cn.granitech.variantorm.pojo.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DecimalField
extends ActualField {
    @Override
    public Object fromJson(Object jsonValue) {
        if (jsonValue == null) {
            return null;
        }
        if (jsonValue instanceof BigDecimal) {
            return jsonValue;
        }
        if (jsonValue instanceof Long) {
            return BigDecimal.valueOf((Long)jsonValue);
        }
        if (jsonValue instanceof Integer) {
            return new BigDecimal((Integer)jsonValue);
        }
        if (jsonValue instanceof String) {
            return new BigDecimal(((String)jsonValue).replaceAll(",", ""));
        }
        if (jsonValue instanceof Double) {
            return BigDecimal.valueOf((Double)jsonValue);
        }
        throw new IllegalArgumentException(new StringBuilder().insert(0, NullFieldValueException.ALLATORIxDEMO("\u000fa\u0010n\nf\u0002/\u0002n\u0012nFi\t}\u000bn\u00125FT")).append(jsonValue).append("]").toString());
    }

    @Override
    public void setParamValue(PreparedStatement pstmt, int index, Object value, PersistenceManager pm) {
        block3: {
            try {
                if (value != null) break block3;
                pstmt.setNull(index, 3);
                return;
            }
            catch (SQLException a2) {
                throw new DataAccessException(NullFieldValueException.ALLATORIxDEMO("5j\u0012/\u0002j\u0005f\u000bn\n/\u0012`F_\u0014j\u0016n\u0014j\u0002\\\u0012n\u0012j\u000bj\b{Fj\u0014}\t}"), a2);
            }
        }
        pstmt.setBigDecimal(index, (BigDecimal)value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object readDBValue(PersistenceManager pm, Field field, ResultSet rs, int index) {
        try {
            ResultSet resultSet = rs;
            BigDecimal a2 = resultSet.getBigDecimal(index);
            if (resultSet.wasNull()) {
                return null;
            }
            int a3 = field.getFieldViewModel() == null || field.getFieldViewModel().getPrecision() == null ? 2 : field.getFieldViewModel().getPrecision();
            return a2.setScale(a3, RoundingMode.HALF_UP);
        }
        catch (SQLException a4) {
            throw new DataAccessException(InvalidEntityException.ALLATORIxDEMO("Y\u0001jDz\u0001}\rs\u0005rDx\u0016q\t>6{\u0017k\bj7{\u0010>\u0001l\u0016q\u0016"), a4);
        }
    }

    @Override
    public String getName() {
        return "Decimal";
    }

    public DecimalField() {
        super(BigDecimal.class);
    }
}

