/*
 * Decompiled with CFR 0.152.
 */
package cn.granitech.variantorm.metadata.fieldtype;

import cn.granitech.variantorm.exception.DataAccessException;
import cn.granitech.variantorm.exception.NullFieldValueException;
import cn.granitech.variantorm.metadata.impl.ActualField;
import cn.granitech.variantorm.persistence.PersistenceManager;
import cn.granitech.variantorm.pojo.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;

public class BigIntegerField
extends ActualField {
    @Override
    public Object fromJson(Object jsonValue) {
        if (jsonValue == null) {
            return null;
        }
        if (jsonValue instanceof BigDecimal) {
            return ((BigDecimal)jsonValue).setScale(0, RoundingMode.HALF_UP).longValue();
        }
        if (jsonValue instanceof Long) {
            return (Long)jsonValue;
        }
        if (jsonValue instanceof String) {
            if (StringUtils.isBlank((CharSequence)((String)jsonValue))) {
                return null;
            }
            return new Long(((String)jsonValue).replaceAll(",", ""));
        }
        if (jsonValue instanceof Integer) {
            return (Integer)jsonValue;
        }
        throw new IllegalArgumentException(new StringBuilder().insert(0, NullFieldValueException.ALLATORIxDEMO("\u000fa\u0010n\nf\u0002/\u0002n\u0012nFi\t}\u000bn\u00125FT")).append(jsonValue).append("]").toString());
    }

    @Override
    public String getName() {
        return "BigInteger";
    }

    @Override
    public Object readDBValue(PersistenceManager pm, Field field, ResultSet rs, int index) {
        long a2;
        block3: {
            try {
                ResultSet resultSet = rs;
                a2 = resultSet.getLong(index);
                if (!resultSet.wasNull()) break block3;
                return null;
            }
            catch (SQLException a3) {
                throw new DataAccessException(NullFieldValueException.ALLATORIxDEMO("!j\u0012/\u000fa\u0012j\u0001j\u0014/\u0000}\tbF]\u0003|\u0013c\u0012\\\u0003{Fj\u0014}\t}"), a3);
            }
        }
        return a2;
    }

    @Override
    public void setParamValue(PreparedStatement pstmt, int index, Object value, PersistenceManager pm) {
        block3: {
            try {
                if (value != null) break block3;
                pstmt.setNull(index, -5);
                return;
            }
            catch (SQLException a2) {
                throw new DataAccessException(NullFieldValueException.ALLATORIxDEMO("5j\u0012/\u000fa\u0012j\u0001j\u0014/\u0012`F_\u0014j\u0016n\u0014j\u0002\\\u0012n\u0012j\u000bj\b{Fj\u0014}\t}"), a2);
            }
        }
        pstmt.setLong(index, (Long)value);
    }

    public BigIntegerField() {
        super(Long.class);
    }
}

