/*
 * Decompiled with CFR 0.152.
 */
package cn.granitech.variantorm.persistence;

import cn.granitech.variantorm.metadata.ID;
import cn.granitech.variantorm.metadata.MetadataManager;
import cn.granitech.variantorm.persistence.DataQuery;
import cn.granitech.variantorm.persistence.EntityRecord;
import cn.granitech.variantorm.persistence.RecordQuery;
import cn.granitech.variantorm.persistence.cache.OptionCacheManager;
import cn.granitech.variantorm.persistence.cache.QueryCache;
import cn.granitech.variantorm.persistence.cache.TagCacheManager;
import cn.granitech.variantorm.persistence.dialect.Dialect;
import cn.granitech.variantorm.persistence.license.LicenseInfo;
import cn.granitech.variantorm.persistence.queryCompiler.SqlCompiler;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;

public interface PersistenceManager {
    public MetadataManager getMetadataManager();

    public SqlCompiler getSqlCompiler();

    public Dialect getDialect();

    public DataSource getDataSource();

    public JdbcTemplate getJdbcTemplate();

    public EntityRecord newRecord(String var1);

    public ID insert(EntityRecord var1);

    public ID clone(EntityRecord var1, Boolean var2);

    public Boolean update(EntityRecord var1);

    public Boolean delete(ID var1, String ... var2);

    public void restore(ID var1);

    public DataQuery createDataQuery();

    public RecordQuery createRecordQuery();

    public boolean batchDelete(String var1, String var2);

    public List<ID> batchDeleteAndReturnIdList(String var1, String var2);

    public boolean batchAssign(String var1, String var2, ID var3, ID var4);

    public Integer batchUpdate(String var1, Map<String, Object> var2, String var3);

    public OptionCacheManager getOptionCacheManager();

    public TagCacheManager getTagCacheManager();

    public QueryCache getQueryCache();

    public LicenseInfo validateLicense(String var1, String var2, String var3, String var4, Integer var5, String var6);

    public LicenseInfo getLicenseInfo();
}

