/*
 * Decompiled with CFR 0.152.
 */
package cn.granitech.variantorm.metadata.impl;

import cn.granitech.variantorm.exception.InvalidEntityException;
import cn.granitech.variantorm.metadata.MetadataManager;
import cn.granitech.variantorm.metadata.impl.I;
import cn.granitech.variantorm.persistence.cache.OptionCacheManager;
import cn.granitech.variantorm.persistence.dialect.Dialect;
import cn.granitech.variantorm.pojo.Entity;
import cn.granitech.variantorm.pojo.Field;
import cn.granitech.variantorm.util.BooleanHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class MetadataManagerImpl
implements MetadataManager {
    private Dialect D;
    private final Map<Integer, Entity> h;
    private final Map<String, Entity> ALLATORIxDEMO;

    @Override
    public Entity getEntity(String entityName) throws InvalidEntityException {
        Entity a2 = this.ALLATORIxDEMO.get(entityName);
        if (a2 == null) {
            throw new InvalidEntityException(new StringBuilder().insert(0, OptionCacheManager.ALLATORIxDEMO("a(\u000f4Z$GgJ)[.[>\u000f)N*J}\u000f")).append(entityName).toString());
        }
        return a2;
    }

    @Override
    public Dialect getDialect() {
        return this.D;
    }

    @Override
    public Entity getEntity(int entityCode) throws InvalidEntityException {
        if (entityCode <= 0) {
            throw new IllegalArgumentException(BooleanHelper.ALLATORIxDEMO("-[\u001c\\\u001cLHV\u0007Q\r\u0015\u0005@\u001bAHW\r\u0015\u000fG\rT\u001cP\u001a\u0015\u001c]\t[H\u0005F"));
        }
        Entity a2 = this.h.get(entityCode);
        if (a2 == null) {
            throw new InvalidEntityException(new StringBuilder().insert(0, OptionCacheManager.ALLATORIxDEMO("a(\u000f4Z$GgJ)[.[>\u000f$@#J}\u000f")).append(entityCode).toString());
        }
        return a2;
    }

    @Override
    public boolean containsEntity(String entityName) {
        return this.ALLATORIxDEMO.containsKey(entityName);
    }

    @Override
    public boolean addField(String entityName, Field field) {
        Entity a2 = this.ALLATORIxDEMO.get(entityName);
        if (a2 == null) {
            throw new IllegalArgumentException(new StringBuilder().insert(0, OptionCacheManager.ALLATORIxDEMO("\u000eA1N+F#\u000f\"A3F3VgA&B\"\u000f(]gJ)[.[>\u000f)@3\u000f\"W.\\3\\}\u000f")).append(entityName).toString());
        }
        return a2.addField(field);
    }

    @Override
    public Boolean hasEntityCode(Integer entityCode) {
        return this.h.containsKey(entityCode);
    }

    @Override
    public boolean removeEntity(String entityName) {
        Entity a2 = this.ALLATORIxDEMO.remove(entityName);
        if (a2 == null) {
            throw new IllegalArgumentException(new StringBuilder().insert(0, BooleanHelper.ALLATORIxDEMO("|\u0006C\tY\u0001QHP\u0006A\u0001A\u0011\u0015\u0006T\u0005PHZ\u001a\u0015\r[\u001c\\\u001cLH[\u0007AHP\u0010\\\u001bA\u001b\u000fH")).append(entityName).toString());
        }
        if (a2.getMainEntity() != null) {
            Set<Entity> a3 = a2.getMainEntity().getDetailEntitySet();
            LinkedHashSet<Entity> a4 = new LinkedHashSet<Entity>();
            for (Entity a5 : a3) {
                if (a5.getName().equals(entityName)) continue;
                a4.add(a5);
            }
            a2.getMainEntity().setDetailEntitySet(a4);
        }
        this.h.remove(a2.getEntityCode());
        a2.setMetadataManager(null);
        return true;
    }

    public MetadataManagerImpl() {
        MetadataManagerImpl metadataManagerImpl = this;
        MetadataManagerImpl metadataManagerImpl2 = this;
        metadataManagerImpl.ALLATORIxDEMO = new HashMap<String, Entity>();
        metadataManagerImpl.h = new HashMap<Integer, Entity>();
        metadataManagerImpl.D = null;
    }

    @Override
    public boolean containsEntity(int entityCode) {
        if (entityCode <= 0) {
            throw new IllegalArgumentException(BooleanHelper.ALLATORIxDEMO("-[\u001c\\\u001cLHV\u0007Q\r\u0015\u0005@\u001bAHW\r\u0015\u000fG\rT\u001cP\u001a\u0015\u001c]\t[H\u0005F"));
        }
        return this.h.containsKey(entityCode);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean updateEntity(Entity entity) {
        void newEntity;
        MetadataManagerImpl metadataManagerImpl = this;
        newEntity.setMetadataManager(metadataManagerImpl);
        metadataManagerImpl.ALLATORIxDEMO.put(newEntity.getName(), (Entity)newEntity);
        return true;
    }

    @Override
    public boolean updateField(String entityName, String fieldName, Field field) {
        Entity a2 = this.ALLATORIxDEMO.get(entityName);
        if (a2 == null) {
            throw new IllegalArgumentException(new StringBuilder().insert(0, BooleanHelper.ALLATORIxDEMO("|\u0006C\tY\u0001QHP\u0006A\u0001A\u0011\u0015\u0006T\u0005PHZ\u001a\u0015\r[\u001c\\\u001cLH[\u0007AHP\u0010\\\u001bA\u001b\u000fH")).append(entityName).toString());
        }
        return a2.updateField(fieldName, field);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<Entity> getEntitySet() {
        void a2;
        ArrayList<Entity> arrayList = new ArrayList<Entity>(this.ALLATORIxDEMO.values());
        void v0 = a2;
        Collections.sort(v0, new I(this));
        return v0;
    }

    @Override
    public boolean removeField(Integer entityCode, String fieldName) {
        Entity a2 = this.h.get(entityCode);
        if (a2 == null) {
            throw new IllegalArgumentException(new StringBuilder().insert(0, BooleanHelper.ALLATORIxDEMO("|\u0006C\tY\u0001QHP\u0006A\u0001A\u0011\u0015\u000bZ\fPHZ\u001a\u0015\r[\u001c\\\u001cLH[\u0007AHP\u0010\\\u001bA\u001b\u000fH")).append(entityCode).toString());
        }
        return a2.removeField(fieldName);
    }

    @Override
    public List<String> getAllTagsOfEntity() {
        HashSet a2 = new HashSet();
        this.ALLATORIxDEMO.forEach((key, entity) -> {
            if (StringUtils.isNotBlank((CharSequence)entity.getTags())) {
                int n;
                String[] stringArray = entity.getTags().split(",");
                int n2 = stringArray.length;
                int n3 = n = 0;
                while (n3 < n2) {
                    String a2 = stringArray[n];
                    if (StringUtils.isNotBlank((CharSequence)a2.trim())) {
                        a2.add(a2);
                    }
                    n3 = ++n;
                }
            }
        });
        return new ArrayList<String>(a2);
    }

    @Override
    public boolean addEntity(Entity newEntity) {
        if (newEntity.getMetadataManager() != null) {
            throw new IllegalArgumentException(new StringBuilder().insert(0, OptionCacheManager.ALLATORIxDEMO("\u0002A3F3Vgt")).append(newEntity.getName()).append(BooleanHelper.ALLATORIxDEMO("5\u0015\u001fT\u001b\u0015\u0007B\u0006P\f\u0015\nLHZ\u001c]\rGHx\rA\tq\tA\tx\t[\tR\rGF")).toString());
        }
        int a2 = newEntity.getEntityCode();
        if (a2 <= 0) {
            throw new IllegalArgumentException(new StringBuilder().insert(0, OptionCacheManager.ALLATORIxDEMO("f)Y&C.KgJ)[.[>\u000f$@#J}\u000f")).append(a2).toString());
        }
        Iterator<String> iterator = this.ALLATORIxDEMO.keySet().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equalsIgnoreCase(newEntity.getName())) continue;
            throw new IllegalArgumentException(new StringBuilder().insert(0, BooleanHelper.ALLATORIxDEMO("q\u001dE\u0004\\\u000bT\u001cP\f\u0015\r[\u001c\\\u001cLHA\u0011E\r\u0015\u000bZ\fPR\u0015\r[\u001c\\\u001cLU")).append(newEntity.getName()).append(OptionCacheManager.ALLATORIxDEMO("\u0003g[>_\"l(K\"\u0012")).append(newEntity.getEntityCode()).toString());
        }
        if (this.h.containsKey(a2)) {
            throw new IllegalArgumentException(new StringBuilder().insert(0, BooleanHelper.ALLATORIxDEMO("q\u001dE\u0004\\\u000bT\u001cP\f\u0015\r[\u001c\\\u001cLHA\u0011E\r\u0015\u000bZ\fPR\u0015\r[\u001c\\\u001cLU")).append(newEntity.getName()).append(OptionCacheManager.ALLATORIxDEMO("\u0003g[>_\"l(K\"\u0012")).append(newEntity.getEntityCode()).toString());
        }
        Entity entity = newEntity;
        MetadataManagerImpl metadataManagerImpl = this;
        entity.setMetadataManager(metadataManagerImpl);
        metadataManagerImpl.ALLATORIxDEMO.put(newEntity.getName(), newEntity);
        this.h.put(a2, newEntity);
        if (entity.getMainEntity() != null && newEntity.isDetailEntityFlag()) {
            Entity a3 = newEntity.getMainEntity();
            a3.addDetailEntity(newEntity.getName());
        }
        return true;
    }

    @Override
    public void setDialect(Dialect dialect) {
        this.D = dialect;
    }

    @Override
    public boolean removeField(String entityName, String fieldName) {
        Entity a2 = this.ALLATORIxDEMO.get(entityName);
        if (a2 == null) {
            throw new IllegalArgumentException(new StringBuilder().insert(0, OptionCacheManager.ALLATORIxDEMO("\u000eA1N+F#\u000f\"A3F3VgA&B\"\u000f(]gJ)[.[>\u000f)@3\u000f\"W.\\3\\}\u000f")).append(entityName).toString());
        }
        return a2.removeField(fieldName);
    }
}

