/*
 * Decompiled with CFR 0.152.
 */
package cn.granitech.variantorm.metadata.fieldtype;

import cn.granitech.variantorm.constant.CommonFields;
import cn.granitech.variantorm.exception.DataAccessException;
import cn.granitech.variantorm.metadata.impl.ActualField;
import cn.granitech.variantorm.persistence.PersistenceManager;
import cn.granitech.variantorm.persistence.cache.OptionCacheManager;
import cn.granitech.variantorm.pojo.Field;
import cn.granitech.variantorm.util.DateHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;

public class DateTimeField
extends ActualField {
    @Override
    public String getName() {
        return "DateTime";
    }

    @Override
    public Object fromJson(Object jsonValue) {
        if (jsonValue == null) {
            return null;
        }
        if (jsonValue instanceof java.sql.Date) {
            return (java.sql.Date)jsonValue;
        }
        if (jsonValue instanceof Timestamp) {
            return (Timestamp)jsonValue;
        }
        if (jsonValue instanceof Date) {
            return new Timestamp(((Date)jsonValue).getTime());
        }
        Date a2 = DateHelper.parseDateTime((String)jsonValue);
        return new Timestamp(a2.getTime());
    }

    public DateTimeField() {
        super(Date.class);
    }

    @Override
    public void setParamValue(PreparedStatement pstmt, int index, Object value, PersistenceManager pm) {
        block3: {
            try {
                if (value != null) break block3;
                pstmt.setNull(index, 93);
                return;
            }
            catch (SQLException a2) {
                throw new DataAccessException(OptionCacheManager.ALLATORIxDEMO("|\"[gK&[\"[.B\"\u000f3@g\u007f5J7N5J#|3N3J*J)[gJ5](]"), a2);
            }
        }
        pstmt.setTimestamp(index, new Timestamp(((Date)value).getTime()));
    }

    @Override
    public Object readDBValue(PersistenceManager pm, Field field, ResultSet rs, int index) {
        Timestamp a2;
        block3: {
            try {
                ResultSet resultSet = rs;
                a2 = resultSet.getTimestamp(index);
                if (!resultSet.wasNull()) break block3;
                return null;
            }
            catch (SQLException a3) {
                throw new DataAccessException(CommonFields.ALLATORIxDEMO("\u0013\r H0\t \t \u00019\rt\u000e&\u00079H\u0006\r'\u001d8\u001c\u0007\r H1\u001a&\u0007&"), a3);
            }
        }
        return new Date(a2.getTime());
    }
}

