/*
 * Decompiled with CFR 0.152.
 */
package cn.granitech.variantorm.dbmapping;

import cn.granitech.variantorm.constant.MetaEntityColumns;
import cn.granitech.variantorm.constant.ReservedFields;
import cn.granitech.variantorm.constant.SystemEntities;
import cn.granitech.variantorm.dbmapping.DBMappingHelper;
import cn.granitech.variantorm.dbmapping.I;
import cn.granitech.variantorm.dbmapping.a;
import cn.granitech.variantorm.dbmapping.ddl.DBDDL;
import cn.granitech.variantorm.dbmapping.ddl.DBDDLHelper;
import cn.granitech.variantorm.dbmapping.j;
import cn.granitech.variantorm.exception.DuplicateEntityException;
import cn.granitech.variantorm.exception.DuplicateFieldException;
import cn.granitech.variantorm.exception.LicenseException;
import cn.granitech.variantorm.metadata.MetadataManager;
import cn.granitech.variantorm.metadata.fieldtype.FieldTypes;
import cn.granitech.variantorm.persistence.PersistenceManager;
import cn.granitech.variantorm.persistence.cache.TagCacheManager;
import cn.granitech.variantorm.persistence.dialect.Dialect;
import cn.granitech.variantorm.persistence.license.LicenseInfo;
import cn.granitech.variantorm.pojo.Entity;
import cn.granitech.variantorm.pojo.Field;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;

public class DBMappingManager {
    private final PersistenceManager a;
    private final DBDDL D;
    private final DataSource h;
    private final MetadataManager ALLATORIxDEMO;

    public void updateField(int entityCode, Field field) {
        if (entityCode != field.getEntityCode()) {
            throw new IllegalArgumentException(TagCacheManager.ALLATORIxDEMO("\u00039\u0012>\u0012.F4\t3\u0003w\u000b>\u0015:\u0007#\u0005?\u00033G"));
        }
        Entity a2 = this.ALLATORIxDEMO.getEntity(entityCode);
        Field a3 = a2.getField(field.getName());
        Field field2 = field;
        Field field3 = a3;
        Field field4 = field;
        field4.setName(a3.getName());
        field4.setPhysicalName(a3.getPhysicalName());
        field.setType(field3.getType());
        field2.setIdFieldFlag(field3.isIdFieldFlag());
        field2.setMainDetailFieldFlag(a3.isMainDetailFieldFlag());
        if (field2.getType() == FieldTypes.REFERENCE) {
            field.setReferTo(a3.getReferTo());
        }
        if (field.getType() != FieldTypes.REFERENCELIST) {
            this.D.alterFieldColumn(field);
        }
        DBMappingManager dBMappingManager = this;
        DBMappingHelper.updateMetaFieldRecord(dBMappingManager.h, dBMappingManager.ALLATORIxDEMO, entityCode, field);
        dBMappingManager.ALLATORIxDEMO.updateField(a2.getName(), field.getName(), field);
    }

    /*
     * WARNING - void declaration
     */
    public void updateEntity(Entity entity) {
        void entity2;
        DBMappingManager dBMappingManager = this;
        DBMappingHelper.updateMetaEntityRecord(this.h, dBMappingManager.ALLATORIxDEMO, (Entity)entity2);
        dBMappingManager.ALLATORIxDEMO.updateEntity((Entity)entity2);
    }

    public DBMappingManager(DataSource dataSource, MetadataManager mdm) {
        DataSource dataSource2 = dataSource;
        DBMappingManager dBMappingManager = this;
        this.h = dataSource;
        dBMappingManager.ALLATORIxDEMO = mdm;
        dBMappingManager.a = null;
        this.D = DBDDLHelper.getDBDDL(dataSource2);
        DBMappingHelper.loadMetadataFromDB(dataSource2, this.ALLATORIxDEMO);
    }

    static /* synthetic */ MetadataManager ALLATORIxDEMO(DBMappingManager x0) {
        return x0.ALLATORIxDEMO;
    }

    public void deleteField(String entityName, String fieldName) {
        if (ReservedFields.isReservedField(entityName, fieldName)) {
            throw new IllegalStateException(MetaEntityColumns.ALLATORIxDEMO("\u7c92\u7ea2\u4fb4\u7524\u5b3e\u6bc8\u4e64\u5392\u5249\u9619H"));
        }
        Field a2 = this.ALLATORIxDEMO.getEntity(entityName).getField(fieldName);
        int a3 = a2.getOwner().getEntityCode();
        if (a2.getType() != FieldTypes.REFERENCELIST) {
            this.D.deleteFieldColumn(a2);
        }
        DBMappingManager dBMappingManager = this;
        DBMappingHelper.deleteMetaFieldRecord(dBMappingManager.h, dBMappingManager.ALLATORIxDEMO, a3, fieldName);
        dBMappingManager.ALLATORIxDEMO.removeField(entityName, fieldName);
    }

    private /* synthetic */ void k(Entity entity, MetadataManager mdm, String fieldName, String fieldLabel, Boolean nullable, Boolean creatable, Boolean updatable) {
        Field a2;
        Field field = a2 = new Field();
        a2.setName(fieldName);
        field.setLabel(fieldLabel);
        a2.setPhysicalName(mdm.getDialect().getRealFieldName(fieldName));
        field.setType(FieldTypes.DATETIME);
        a2.setNullable(nullable);
        a2.setCreatable(creatable);
        a2.setUpdatable(updatable);
        a2.setOwner(entity);
        MetadataManager metadataManager = mdm;
        DBMappingHelper.insertMetaFieldRecord(this.h, metadataManager, entity.getEntityCode(), a2);
        metadataManager.addField(entity.getName(), a2);
    }

    private /* synthetic */ void e(Entity entity, MetadataManager mdm, String fieldName, String fieldLabel, Boolean nullable, Boolean creatable, Boolean updatable) {
        Field a2;
        Field field = a2 = new Field();
        a2.setName(fieldName);
        field.setLabel(fieldLabel);
        a2.setPhysicalName(mdm.getDialect().getRealFieldName(fieldName));
        field.setType(FieldTypes.TEXTAREA);
        a2.setNullable(nullable);
        a2.setCreatable(creatable);
        a2.setUpdatable(updatable);
        a2.setOwner(entity);
        MetadataManager metadataManager = mdm;
        DBMappingHelper.insertMetaFieldRecord(this.h, metadataManager, entity.getEntityCode(), a2);
        metadataManager.addField(entity.getName(), a2);
    }

    public void createEntity(Entity entity) {
        Object a2;
        Object a3;
        if (this.a != null && ((LicenseInfo)(a3 = this.a.getLicenseInfo())).getEntityLimit() != null) {
            a2 = ((LicenseInfo)a3).getEntityLimit();
            Dialect a4 = this.a.getDialect();
            Object[] objectArray = new Object[2];
            objectArray[0] = a4.getQuotedTableName(MetaEntityColumns.ALLATORIxDEMO("\u001d\"\u0004\u0018\u001d\u001c6\u0018\u0007\t\u0000\t\u0010"));
            objectArray[1] = a4.getQuotedIdentifier("entityCode");
            String a5 = String.format(TagCacheManager.ALLATORIxDEMO("F\u0004#\u001b#\u00142w\u00058\u00139\u0012\u007fL~F\u00114\u0018+wC$F \u000e2\u00142Fr\u0015wXwWgVgF"), objectArray);
            Integer a6 = (Integer)new JdbcTemplate(this.h).queryForObject(a5, Integer.class);
            if (a6 != null && a6 >= (Integer)a2) {
                Object[] objectArray2 = new Object[1];
                objectArray2[0] = a2;
                throw new LicenseException(String.format(TagCacheManager.ALLATORIxDEMO("\u5f04\u522b\u7cac\u7eb9\u721f\u674a\u6757\u597c\u6578\u6367r\u0002\u4e7d\u818c\u5bcd\u4e2f\u5bc9\u4f35\uff5b\u5d94\u8dd2\u519c\u6b33\u9636\u5261\uff67"), objectArray2));
            }
        }
        if (DBMappingHelper.checkEntityExists(this.h, entity.getName())) {
            throw new DuplicateEntityException(new StringBuilder().insert(0, MetaEntityColumns.ALLATORIxDEMO("\u5be3\u4f3a")).append(entity.getName()).append(TagCacheManager.ALLATORIxDEMO("\u5da5\u5b3e\u577fG")).toString());
        }
        DBMappingManager dBMappingManager = this;
        if (DBMappingHelper.checkTableExists(dBMappingManager.h, dBMappingManager.ALLATORIxDEMO, entity.getPhysicalName())) {
            throw new IllegalStateException(new StringBuilder().insert(0, MetaEntityColumns.ALLATORIxDEMO("\u650d\u6307\u5eee\u8801")).append(entity.getPhysicalName()).append(TagCacheManager.ALLATORIxDEMO("\u5da5\u5b3e\u577fG")).toString());
        }
        DBMappingManager dBMappingManager2 = this;
        dBMappingManager2.D.createEntityTable(entity);
        DBMappingHelper.insertMetaEntityRecord(dBMappingManager2.h, this.ALLATORIxDEMO, entity);
        dBMappingManager2.ALLATORIxDEMO.addEntity(entity);
        a3 = entity.getIdField();
        DBMappingManager dBMappingManager3 = this;
        a2 = dBMappingManager3.ALLATORIxDEMO.getDialect().getRealFieldName(((Field)a3).getPhysicalName());
        ((Field)a3).setPhysicalName((String)a2);
        DBMappingManager dBMappingManager4 = this;
        DBMappingHelper.insertMetaFieldRecord(dBMappingManager3.h, dBMappingManager4.ALLATORIxDEMO, entity.getEntityCode(), (Field)a3);
        dBMappingManager4.ALLATORIxDEMO.addField(entity.getName(), (Field)a3);
        DBMappingManager dBMappingManager5 = this;
        DBMappingManager dBMappingManager6 = this;
        Entity entity2 = entity;
        DBMappingManager dBMappingManager7 = this;
        dBMappingManager7.k(entity, dBMappingManager7.ALLATORIxDEMO, "createdOn", MetaEntityColumns.ALLATORIxDEMO("\u5266\u5e93\u658b\u959d"), false, false, false);
        dBMappingManager6.ALLATORIxDEMO(entity2, dBMappingManager7.ALLATORIxDEMO, "createdBy", TagCacheManager.ALLATORIxDEMO("\u524c\u5e9c\u757f\u6251"), "User", false, false, false);
        dBMappingManager5.k(entity2, dBMappingManager6.ALLATORIxDEMO, "modifiedOn", MetaEntityColumns.ALLATORIxDEMO("\u677d\u8fb8\u4f93\u6550\u658b\u959d"), true, false, false);
        dBMappingManager5.ALLATORIxDEMO(entity, dBMappingManager5.ALLATORIxDEMO, "modifiedBy", TagCacheManager.ALLATORIxDEMO("\u4fb9\u655f\u757f\u6251"), "User", true, false, false);
        if (entity.isAuthorizable() || entity.isAssignable()) {
            DBMappingManager dBMappingManager8 = this;
            Entity entity3 = entity;
            dBMappingManager8.ALLATORIxDEMO(entity3, this.ALLATORIxDEMO, "ownerUser", MetaEntityColumns.ALLATORIxDEMO("\u623d\u5c37\u7555\u625e"), "User", false, false, false);
            dBMappingManager8.ALLATORIxDEMO(entity3, dBMappingManager8.ALLATORIxDEMO, "ownerDepartment", TagCacheManager.ALLATORIxDEMO("\u6217\u5c38\u90bf\u958e"), "Department", false, false, false);
        }
    }

    public void deleteEntity(String entityName) {
        if (SystemEntities.isInternalEntity(entityName) || SystemEntities.isSystemEntity(entityName)) {
            throw new IllegalStateException(MetaEntityColumns.ALLATORIxDEMO("\u7c86\u7eb6\u5be3\u4f3a\u307c\u51ec\u9095\u5bf7\u4f2e\u4e64\u5392\u5249\u9619H"));
        }
        DBMappingManager dBMappingManager = this;
        Entity a2 = dBMappingManager.ALLATORIxDEMO.getEntity(entityName);
        dBMappingManager.D.deleteEntityTable(a2);
        DBMappingHelper.deleteMetaEntityRecord(dBMappingManager.h, this.ALLATORIxDEMO, entityName, a2.getEntityCode());
        dBMappingManager.ALLATORIxDEMO.removeEntity(entityName);
    }

    /*
     * WARNING - void declaration
     */
    public void createApprovalSystemFields(Entity entity) {
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        int a7 = entity.getEntityCode();
        Field field = new Field();
        void v0 = a6;
        void v1 = a6;
        void v2 = a6;
        a6.setName("approvalConfigId");
        v2.setLabel(TagCacheManager.ALLATORIxDEMO("\u5bf6\u621f\u6d16\u7a6d"));
        v2.setPhysicalName("approvalConfigId");
        v2.setType(FieldTypes.REFERENCE);
        a6.setReferTo(new a(this));
        v1.setNullable(true);
        v1.setCreatable(false);
        v0.setUpdatable(false);
        v0.setOwner(entity);
        DBMappingManager dBMappingManager = this;
        this.createField(a7, (Field)a6);
        Field field2 = new Field();
        void v4 = a5;
        void v5 = a5;
        void v6 = a5;
        a5.setName("approvalStatus");
        v6.setLabel(MetaEntityColumns.ALLATORIxDEMO("\u5bdc\u6210\u72cb\u6068"));
        v6.setPhysicalName("approvalStatus");
        v6.setType(FieldTypes.STATUS);
        v5.setNullable(true);
        v5.setCreatable(false);
        v4.setUpdatable(false);
        v4.setOwner(entity);
        dBMappingManager.createField(a7, (Field)a5);
        Field field3 = new Field();
        void v7 = a4;
        void v8 = a4;
        void v9 = a4;
        void v10 = a4;
        a4.setName("lastApprovedBy");
        v10.setLabel(TagCacheManager.ALLATORIxDEMO("\u6766\u8f86\u5bc7\u622e\u4edc"));
        v9.setPhysicalName("lastApprovedBy");
        v10.setType(FieldTypes.REFERENCE);
        v9.setReferTo(new I(this));
        v8.setNullable(true);
        v8.setCreatable(false);
        v7.setUpdatable(false);
        v7.setOwner(entity);
        dBMappingManager.createField(a7, (Field)a4);
        Field field4 = new Field();
        void v11 = a3;
        void v12 = a3;
        void v13 = a3;
        a3.setName("lastApprovedOn");
        v13.setLabel(MetaEntityColumns.ALLATORIxDEMO("\u677d\u8fb8\u5bdc\u6210\u658b\u959d"));
        v13.setPhysicalName("lastApprovedOn");
        v13.setType(FieldTypes.DATETIME);
        v12.setNullable(true);
        v12.setCreatable(false);
        v11.setUpdatable(false);
        v11.setOwner(entity);
        this.createField(a7, (Field)a3);
        Field field5 = new Field();
        void v14 = a2;
        void v15 = a2;
        void v16 = a2;
        a2.setName("lastApprovalRemark");
        v16.setLabel(TagCacheManager.ALLATORIxDEMO("\u6757\u8fb7\u5bf6\u621f\u622e\u6c8e"));
        v16.setPhysicalName("lastApprovalRemark");
        v16.setType(FieldTypes.TEXTAREA);
        v15.setNullable(true);
        v15.setCreatable(false);
        v14.setUpdatable(false);
        v14.setOwner(entity);
        dBMappingManager.createField(a7, (Field)a2);
    }

    public DBDDL getDBDDL() {
        return this.D;
    }

    public void createField(int entityCode, Field field) {
        if (DBMappingHelper.checkFieldExists(this.h, field.getOwner().getEntityCode(), field.getName())) {
            throw new DuplicateFieldException(new StringBuilder().insert(0, TagCacheManager.ALLATORIxDEMO("\u5b00\u6bd3")).append(field.getName()).append(MetaEntityColumns.ALLATORIxDEMO("\u5d9b\u5b25\u5741")).toString());
        }
        String a2 = this.ALLATORIxDEMO.getDialect().getRealFieldName(field.getPhysicalName());
        Field field2 = field;
        field2.setPhysicalName(a2);
        if (field2.getType() != FieldTypes.REFERENCELIST) {
            this.D.createFieldColumn(field);
        }
        DBMappingManager dBMappingManager = this;
        DBMappingHelper.insertMetaFieldRecord(dBMappingManager.h, dBMappingManager.ALLATORIxDEMO, entityCode, field);
        dBMappingManager.ALLATORIxDEMO.addField(field.getOwner().getName(), field);
    }

    private /* synthetic */ void ALLATORIxDEMO(Entity entity, MetadataManager mdm, String fieldName, String fieldLabel, String refToEntityName, Boolean nullable, Boolean creatable, Boolean updatable) {
        Field a2;
        Field field = a2 = new Field();
        a2.setName(fieldName);
        field.setLabel(fieldLabel);
        a2.setPhysicalName(mdm.getDialect().getRealFieldName(fieldName));
        field.setType(FieldTypes.REFERENCE);
        a2.setNullable(nullable);
        a2.setCreatable(creatable);
        a2.setUpdatable(updatable);
        Entity a3 = mdm.getEntity(refToEntityName);
        Field field2 = a2;
        a2.setReferTo(new j(this, a3));
        a2.setOwner(entity);
        MetadataManager metadataManager = mdm;
        DBMappingHelper.insertMetaFieldRecord(this.h, metadataManager, entity.getEntityCode(), a2);
        metadataManager.addField(entity.getName(), a2);
    }

    private /* synthetic */ void ALLATORIxDEMO(Entity entity, MetadataManager mdm, String fieldName, String fieldLabel, Boolean nullable, Boolean creatable, Boolean updatable) {
        Field a2;
        Field field = a2 = new Field();
        a2.setName(fieldName);
        field.setLabel(fieldLabel);
        a2.setPhysicalName(mdm.getDialect().getRealFieldName(fieldName));
        field.setType(FieldTypes.INTEGER);
        a2.setNullable(nullable);
        a2.setCreatable(creatable);
        a2.setUpdatable(updatable);
        a2.setOwner(entity);
        MetadataManager metadataManager = mdm;
        DBMappingHelper.insertMetaFieldRecord(this.h, metadataManager, entity.getEntityCode(), a2);
        metadataManager.addField(entity.getName(), a2);
    }

    /*
     * WARNING - void declaration
     */
    public DBMappingManager(DataSource dataSource, MetadataManager metadataManager, PersistenceManager persistenceManager) {
        void pm;
        void mdm;
        void dataSource2;
        DBMappingManager dBMappingManager = this;
        dBMappingManager.h = dataSource2;
        dBMappingManager.ALLATORIxDEMO = mdm;
        this.a = pm;
        this.D = DBDDLHelper.getDBDDL(pm.getSqlCompiler().getDatabaseType(), (DataSource)dataSource2);
        DBMappingHelper.loadMetadataFromDB(dataSource, this.ALLATORIxDEMO);
    }
}

