/*
 * Decompiled with CFR 0.152.
 */
package cn.granitech.variantorm.metadata.fieldtype;

import cn.granitech.variantorm.exception.DataAccessException;
import cn.granitech.variantorm.metadata.impl.ActualField;
import cn.granitech.variantorm.persistence.PersistenceManager;
import cn.granitech.variantorm.persistence.license.LicenseInfo;
import cn.granitech.variantorm.pojo.Field;
import cn.granitech.variantorm.util.MDHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DecimalField
extends ActualField {
    @Override
    public String getName() {
        return "Decimal";
    }

    public DecimalField() {
        super(BigDecimal.class);
    }

    @Override
    public Object fromJson(Object jsonValue) {
        if (jsonValue == null) {
            return null;
        }
        if (jsonValue instanceof BigDecimal) {
            return jsonValue;
        }
        if (jsonValue instanceof Long) {
            return BigDecimal.valueOf((Long)jsonValue);
        }
        if (jsonValue instanceof Integer) {
            return new BigDecimal((Integer)jsonValue);
        }
        if (jsonValue instanceof String) {
            return new BigDecimal(((String)jsonValue).replaceAll(",", ""));
        }
        if (jsonValue instanceof Double) {
            return BigDecimal.valueOf((Double)jsonValue);
        }
        throw new IllegalArgumentException(new StringBuilder().insert(0, LicenseInfo.ALLATORIxDEMO("\u001fG\u0000H\u001a@\u0012\t\u0012H\u0002HVO\u0019[\u001bH\u0002\u0013Vr")).append(jsonValue).append("]").toString());
    }

    @Override
    public void setParamValue(PreparedStatement pstmt, int index, Object value, PersistenceManager pm) {
        block3: {
            try {
                if (value != null) break block3;
                pstmt.setNull(index, 3);
                return;
            }
            catch (SQLException a2) {
                throw new DataAccessException(LicenseInfo.ALLATORIxDEMO("%L\u0002\t\u0012L\u0015@\u001bH\u001a\t\u0002FVy\u0004L\u0006H\u0004L\u0012z\u0002H\u0002L\u001bL\u0018]VL\u0004[\u0019["), a2);
            }
        }
        pstmt.setBigDecimal(index, (BigDecimal)value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object readDBValue(PersistenceManager pm, Field field, ResultSet rs, int index) {
        try {
            ResultSet resultSet = rs;
            BigDecimal a2 = resultSet.getBigDecimal(index);
            if (resultSet.wasNull()) {
                return null;
            }
            int a3 = field.getFieldViewModel() == null || field.getFieldViewModel().getPrecision() == null ? 2 : field.getFieldViewModel().getPrecision();
            return a2.setScale(a3, RoundingMode.HALF_UP);
        }
        catch (SQLException a4) {
            throw new DataAccessException(MDHelper.ALLATORIxDEMO("!j\u0012/\u0002j\u0005f\u000bn\n/\u0000}\tbF]\u0003|\u0013c\u0012\\\u0003{Fj\u0014}\t}"), a4);
        }
    }
}

