/*
 * Decompiled with CFR 0.152.
 */
package cn.granitech.variantorm.metadata.fieldtype;

import cn.granitech.variantorm.constant.CommonFields;
import cn.granitech.variantorm.constant.SystemEntityCodes;
import cn.granitech.variantorm.exception.DataAccessException;
import cn.granitech.variantorm.metadata.impl.ActualField;
import cn.granitech.variantorm.persistence.PersistenceManager;
import cn.granitech.variantorm.pojo.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;

public class IntegerField
extends ActualField {
    @Override
    public String getName() {
        return "Integer";
    }

    public IntegerField() {
        super(Integer.class);
    }

    @Override
    public void setParamValue(PreparedStatement pstmt, int index, Object value, PersistenceManager pm) {
        block3: {
            try {
                if (value != null) break block3;
                pstmt.setNull(index, 4);
                return;
            }
            catch (SQLException a2) {
                throw new DataAccessException(CommonFields.ALLATORIxDEMO(";1\u001ct\u0001:\u001c1\u000f1\u001at\u001c;H\u0004\u001a1\u00185\u001a1\f\u0007\u001c5\u001c1\u00051\u0006 H1\u001a&\u0007&"), a2);
            }
        }
        pstmt.setInt(index, (Integer)value);
    }

    @Override
    public Object readDBValue(PersistenceManager pm, Field field, ResultSet rs, int index) {
        int a2;
        block3: {
            try {
                ResultSet resultSet = rs;
                a2 = resultSet.getInt(index);
                if (!resultSet.wasNull()) break block3;
                return null;
            }
            catch (SQLException a3) {
                throw new DataAccessException(SystemEntityCodes.ALLATORIxDEMO("@#sfn(s#`#ufa4h+'\u0014b5r*s\u0015b2'#u4h4"), a3);
            }
        }
        return a2;
    }

    @Override
    public Object fromJson(Object jsonValue) {
        if (jsonValue == null) {
            return null;
        }
        if (jsonValue instanceof BigDecimal) {
            return ((BigDecimal)jsonValue).setScale(0, RoundingMode.HALF_UP).intValue();
        }
        if (jsonValue instanceof Long) {
            return ((Long)jsonValue).intValue();
        }
        if (jsonValue instanceof String) {
            if (StringUtils.isBlank((CharSequence)((String)jsonValue))) {
                return null;
            }
            return new Integer(((String)jsonValue).replaceAll(",", ""));
        }
        if (jsonValue instanceof Integer) {
            return (Integer)jsonValue;
        }
        throw new IllegalArgumentException(new StringBuilder().insert(0, CommonFields.ALLATORIxDEMO("\u0001:\u001e5\u0004=\ft\f5\u001c5H2\u0007&\u00055\u001cnH\u000f")).append(jsonValue).append("]").toString());
    }
}

