/*
 * Decompiled with CFR 0.152.
 */
package cn.granitech.variantorm.metadata.fieldtype;

import cn.granitech.variantorm.exception.DataAccessException;
import cn.granitech.variantorm.exception.DuplicateFieldException;
import cn.granitech.variantorm.metadata.impl.ActualField;
import cn.granitech.variantorm.persistence.PersistenceManager;
import cn.granitech.variantorm.persistence.cache.TagCacheManager;
import cn.granitech.variantorm.pojo.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;

public class BigIntegerField
extends ActualField {
    @Override
    public String getName() {
        return "BigInteger";
    }

    @Override
    public Object fromJson(Object jsonValue) {
        if (jsonValue == null) {
            return null;
        }
        if (jsonValue instanceof BigDecimal) {
            return ((BigDecimal)jsonValue).setScale(0, RoundingMode.HALF_UP).longValue();
        }
        if (jsonValue instanceof Long) {
            return (Long)jsonValue;
        }
        if (jsonValue instanceof String) {
            if (StringUtils.isBlank((CharSequence)((String)jsonValue))) {
                return null;
            }
            return new Long(((String)jsonValue).replaceAll(",", ""));
        }
        if (jsonValue instanceof Integer) {
            return (Integer)jsonValue;
        }
        throw new IllegalArgumentException(new StringBuilder().insert(0, TagCacheManager.ALLATORIxDEMO(">\b!\u0007;\u000f3F3\u0007#\u0007w\u00008\u0014:\u0007#\\w=")).append(jsonValue).append("]").toString());
    }

    public BigIntegerField() {
        super(Long.class);
    }

    @Override
    public Object readDBValue(PersistenceManager pm, Field field, ResultSet rs, int index) {
        long a2;
        block3: {
            try {
                ResultSet resultSet = rs;
                a2 = resultSet.getLong(index);
                if (!resultSet.wasNull()) break block3;
                return null;
            }
            catch (SQLException a3) {
                throw new DataAccessException(DuplicateFieldException.ALLATORIxDEMO("R\u001ea[|\u0015a\u001er\u001eg[s\tz\u00165)p\b`\u0017a(p\u000f5\u001eg\tz\t"), a3);
            }
        }
        return a2;
    }

    @Override
    public void setParamValue(PreparedStatement pstmt, int index, Object value, PersistenceManager pm) {
        block3: {
            try {
                if (value != null) break block3;
                pstmt.setNull(index, -5);
                return;
            }
            catch (SQLException a2) {
                throw new DataAccessException(TagCacheManager.ALLATORIxDEMO("\u0004\u0003#F>\b#\u00030\u0003%F#\tw6%\u0003'\u0007%\u000335#\u0007#\u0003:\u00039\u0012w\u0003%\u00148\u0014"), a2);
            }
        }
        pstmt.setLong(index, (Long)value);
    }
}

