/*
 * Decompiled with CFR 0.152.
 */
package cn.granitech.variantorm.metadata.fieldtype;

import cn.granitech.variantorm.constant.CommonFields;
import cn.granitech.variantorm.exception.DataAccessException;
import cn.granitech.variantorm.metadata.impl.ActualField;
import cn.granitech.variantorm.persistence.PersistenceManager;
import cn.granitech.variantorm.persistence.cache.TagCacheManager;
import cn.granitech.variantorm.pojo.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DecimalField
extends ActualField {
    @Override
    public Object fromJson(Object jsonValue) {
        if (jsonValue == null) {
            return null;
        }
        if (jsonValue instanceof BigDecimal) {
            return jsonValue;
        }
        if (jsonValue instanceof Long) {
            return BigDecimal.valueOf((Long)jsonValue);
        }
        if (jsonValue instanceof Integer) {
            return new BigDecimal((Integer)jsonValue);
        }
        if (jsonValue instanceof String) {
            return new BigDecimal(((String)jsonValue).replaceAll(",", ""));
        }
        if (jsonValue instanceof Double) {
            return BigDecimal.valueOf((Double)jsonValue);
        }
        throw new IllegalArgumentException(new StringBuilder().insert(0, TagCacheManager.ALLATORIxDEMO(">\b!\u0007;\u000f3F3\u0007#\u0007w\u00008\u0014:\u0007#\\w=")).append(jsonValue).append("]").toString());
    }

    public DecimalField() {
        super(BigDecimal.class);
    }

    @Override
    public String getName() {
        return "Decimal";
    }

    @Override
    public void setParamValue(PreparedStatement pstmt, int index, Object value, PersistenceManager pm) {
        block3: {
            try {
                if (value != null) break block3;
                pstmt.setNull(index, 3);
                return;
            }
            catch (SQLException a) {
                throw new DataAccessException(TagCacheManager.ALLATORIxDEMO("\u0004\u0003#F3\u00034\u000f:\u0007;F#\tw6%\u0003'\u0007%\u000335#\u0007#\u0003:\u00039\u0012w\u0003%\u00148\u0014"), a);
            }
        }
        pstmt.setBigDecimal(index, (BigDecimal)value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object readDBValue(PersistenceManager pm, Field field, ResultSet rs, int index) {
        try {
            ResultSet resultSet = rs;
            BigDecimal a = resultSet.getBigDecimal(index);
            if (resultSet.wasNull()) {
                return null;
            }
            int a2 = field.getFieldViewModel() == null || field.getFieldViewModel().getPrecision() == null ? 2 : field.getFieldViewModel().getPrecision();
            return a.setScale(a2, RoundingMode.HALF_UP);
        }
        catch (SQLException a) {
            throw new DataAccessException(CommonFields.ALLATORIxDEMO("/1\u001ct\f1\u000b=\u00055\u0004t\u000e&\u00079H\u0006\r'\u001d8\u001c\u0007\r H1\u001a&\u0007&"), a);
        }
    }
}

