/*
 * Decompiled with CFR 0.152.
 */
package cn.granitech.variantorm.metadata;

import cn.granitech.variantorm.serializer.IDSerializer;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.UUID;

@JsonSerialize(using=IDSerializer.class)
public final class ID
implements Serializable,
Comparable<ID> {
    private static final long serialVersionUID = 9191596595361472801L;
    private static final String[] PREFIX_SPACE = new String[]{null, "000000", "00000", "0000", "000", "00", "0", ""};
    private String id;
    private int entityCode;

    public ID() {
    }

    public String getId() {
        return this.id;
    }

    public static ID newID(int typeCode) {
        if (typeCode < 0 || typeCode > 99999) {
            throw new IllegalArgumentException("typeCode=" + typeCode);
        }
        String keyPrefix = String.valueOf(typeCode);
        return new ID(PREFIX_SPACE[keyPrefix.length()] + keyPrefix + "-" + ID.getNewUUIDStr());
    }

    public static String getNewUUIDStr() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static boolean isId(Object id) {
        if (id == null) {
            return false;
        }
        if (id instanceof ID) {
            return true;
        }
        try {
            new ID(id.toString());
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static ID valueOf(Object id) {
        if (id == null) {
            throw new IllegalArgumentException("ID could't be null");
        }
        if (id instanceof ID) {
            return (ID)id;
        }
        return new ID(id.toString());
    }

    public ID(String id) {
        if (id == null) {
            throw new NullPointerException("ID could't be null");
        }
        if (id.getBytes().length != 40) {
            throw new IllegalArgumentException("Invalid length of ID, [id: " + id + ", length: " + id.length() + "]");
        }
        int dashPos = id.indexOf(45);
        this.entityCode = Integer.parseInt(id.substring(0, dashPos));
        this.id = id;
    }

    public int getEntityCode() {
        return this.entityCode;
    }

    public String toString() {
        return this.id;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof String) {
            return this.id.equals((String)obj);
        }
        if (!(obj instanceof ID)) {
            return false;
        }
        ID id = (ID)obj;
        return id.id.equals(this.id);
    }

    @Override
    public int compareTo(ID id) {
        return this.id.compareTo(id.id);
    }

    public static void main(String[] args) {
        String uidStr = ID.getNewUUIDStr();
        System.out.println(uidStr);
        ID testId = ID.newID(99988);
        System.out.println(testId);
        ID newId = new ID("003-91fa2267-33b5-4375-b0fd-1662211fb0db");
        System.out.println(newId.getEntityCode());
        newId = new ID("0099988-ed413c3548f14cccb17a4774a7bb45fe");
        System.out.println(newId.getEntityCode());
    }
}

