/**
 * Copyright [2019-Present] [starBlues]
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package com.gitee.starblues.loader;

/**
 * 常量统一定义
 *
 * @author starBlues
 * @since 3.0.0
 * @version 3.0.2
 */
public class LoaderConstant {

    public static final String PROD_CLASSES_PATH = "classes/";
    public static final String PROD_CLASSES_URL_SIGN = "/classes!/";
    public static final String PROD_LIB_PATH = "lib/";

    /**
     * 相对路径符号标志
     */
    public final static String RELATIVE_SIGN = "~";


    /**
     * ================= Manifest Key =====================
     */
    public static final String MAIN_LIB_DIR = "Lib-Dir";
    public static final String MAIN_LIB_INDEXES_SPLIT = " ";

    public static final String START_CLASS = "Start-Class";
    public static final String MAIN_DEVELOPMENT_MODE = "Development-Mode";
    public static final String MAIN_PACKAGE_TYPE = "Main-Package-Type";

    public static final String MAIN_PACKAGE_TYPE_JAR = "jar";
    public static final String MAIN_PACKAGE_TYPE_JAR_OUTER = "jar-outer";



}
