/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.text;

import cn.gongler.util.GonglerUtil;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.function.UnaryOperator;

public class ColumnWidthFiller {
    private static final long serialVersionUID = -5957526185840744064L;
    private final Charset charset;
    private final StringBuilder buf = new StringBuilder();
    private int widthTotal = 0;

    public static ColumnWidthFiller of() {
        return ColumnWidthFiller.GBK();
    }

    private static ColumnWidthFiller GBK() {
        return new ColumnWidthFiller(Charset.forName("GBK"));
    }

    private ColumnWidthFiller(Charset charset) {
        this.charset = charset;
    }

    private int showWidth(String msg) {
        return msg.getBytes(this.charset).length;
    }

    public ColumnWidthFiller add(int width, Object msg) {
        return this.left(width, msg);
    }

    private ColumnWidthFiller left(int width, Object obj) {
        this.widthTotal += width;
        String msg = String.valueOf(GonglerUtil.WithDefault(obj, ""));
        this.buf.append(msg);
        int cha = width - this.showWidth(msg);
        if (cha > 0) {
            for (int i = 0; i < cha; ++i) {
                this.buf.append(' ');
            }
        }
        return this;
    }

    private ColumnWidthFiller right(int width, Object obj) {
        this.widthTotal += width;
        String msg = String.valueOf(GonglerUtil.WithDefault(obj, ""));
        int cha = width - this.showWidth(msg);
        if (cha > 0) {
            for (int i = 0; i < cha; ++i) {
                this.buf.append(' ');
            }
        }
        this.buf.append(msg);
        return this;
    }

    public ColumnWidthFiller skip(int count) {
        for (int i = 0; i < count; ++i) {
            this.buf.append(' ');
        }
        this.widthTotal += count;
        return this;
    }

    public ColumnWidthFiller add(Object val) {
        if (val != null) {
            String msg = String.valueOf(val);
            this.buf.append(msg);
            this.widthTotal += this.showWidth(msg);
        }
        return this;
    }

    public ColumnWidthFiller addAll(UnaryOperator<ColumnWidthFiller> val) {
        return (ColumnWidthFiller)val.apply(this);
    }

    public ColumnWidthFiller forceWidth(int ledWidth) {
        byte[] original = this.buf.toString().getBytes(this.charset);
        if (original.length == ledWidth) {
            return this;
        }
        byte[] copy = new byte[ledWidth];
        Arrays.fill(copy, (byte)32);
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, ledWidth));
        String m = new String(copy, this.charset);
        return ColumnWidthFiller.of().left(ledWidth, m);
    }

    public ColumnWidthFiller forceWidth() {
        return this.forceWidth(this.widthTotal);
    }

    public String build() {
        return this.buf.toString();
    }

    public String toString() {
        return this.buf.toString();
    }
}

