/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.sgeo.line.imp;

import cn.gongler.util.db.DbUtil;
import cn.gongler.util.sgeo.geo.ScopeGroupFactory;
import cn.gongler.util.sgeo.line.LineUpDown;
import cn.gongler.util.sgeo.line.imp.LineBusstop;
import cn.gongler.util.sgeo.line.imp.LineSide;
import cn.gongler.util.sgeo.line.imp.Lowline;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.TreeMap;
import javax.sql.DataSource;

public class LowLineFactory {
    private static final long serialVersionUID = 5017628608159705630L;
    public Map<Long, Lowline> lowlineMap = new TreeMap<Long, Lowline>();
    DataSource refDs = null;

    public LowLineFactory(DataSource ds) {
        this.refDs = ds;
    }

    public void load() throws SQLException {
        Connection conn = this.refDs.getConnection();
        this.load(conn);
    }

    public void load(Connection conn) throws SQLException {
        ScopeGroupFactory.of().loadAllFromDb(conn, true);
        this.loadLine(conn);
    }

    static long getsublineKey(long lineId, int lineSubno) {
        return lineId * 100L | (long)(lineSubno % 100);
    }

    static long getLowlineId(Map<Long, Long> lowlineMap, long lineId, int lineSubno) {
        Long ret = lowlineMap.get(LowLineFactory.getsublineKey(lineId, lineSubno));
        if (ret == null) {
            ret = 0L;
        }
        return ret;
    }

    private void loadLine(Connection conn) throws SQLException {
        final TreeMap tmpLowlineMap = new TreeMap();
        DbUtil.ExecuteQuery(conn, "select * from vw_lowline_map", new DbUtil.RowHandler(){
            Lowline busSubline = Lowline.NULL;

            @Override
            public void rowHandle(ResultSet rs, int rowIndex) throws SQLException {
                long lineId = rs.getLong("LINE_NO");
                int lineSubno = rs.getInt("LINE_SUBNO");
                long lowlineId = rs.getLong("LOWLINE_NO");
                tmpLowlineMap.put(LowLineFactory.getsublineKey(lineId, lineSubno), lowlineId);
            }
        });
        DbUtil.ExecuteQuery(conn, "SELECT T1.*, T2.LINE_NAME, T3.BUSSTOP_NAME FROM BASE_LINE_BUSSTOP T1, BASE_LINE T2, BASE_BUSSTOP T3 WHERE T1.LINE_NO=T2.LINE_NO AND T1.BUSSTOP_NO=T3.BUSSTOP_NO ORDER BY T1.LINE_NO, T1.LINE_SUBNO, T1.UPDOWN, T1.BUSSTOP_SERIAL", new DbUtil.RowHandler(){
            Lowline lastLowline = Lowline.NULL;

            @Override
            public void rowHandle(ResultSet rs, int rowIndex) throws SQLException {
                long lineId = rs.getLong("LINE_NO");
                int lineSubno = rs.getInt("LINE_SUBNO");
                long lowlineId = LowLineFactory.getLowlineId(tmpLowlineMap, lineId, lineSubno);
                int updown = rs.getInt("UPDOWN") - 1;
                String LineName = rs.getString("LINE_NAME");
                String busstopName = rs.getString("BUSSTOP_NAME");
                long busstopId = rs.getLong("BUSSTOP_NO");
                String lowlineName = LineName + "_" + lineSubno;
                this.switchLineIfNeed(lowlineId, lowlineName, lineId, lineSubno, LineName);
                LineBusstop lineBusstop = new LineBusstop(busstopId, busstopName);
                this.lastLowline.appendBusstop(LineUpDown.parse(updown), lineBusstop);
            }

            @Override
            public void finished(int rowIndex) {
                this.switchLineIfNeed(-1L, "", -1L, -1, "");
            }

            private void switchLineIfNeed(long newLowlineId, String newLowlineName, long newLineId, int newLineSubno, String newLineName) {
                long lastLowlineId;
                Lowline lastLowline = this.lastLowline;
                long l = lastLowlineId = lastLowline == null ? -1L : lastLowline.id();
                if (newLowlineId != lastLowlineId) {
                    if (lastLowline != Lowline.NULL) {
                        LowLineFactory.this.lowlineMap.put(lastLowlineId, lastLowline);
                    }
                    if (newLowlineId != -1L) {
                        Lowline nextLowline = new Lowline(newLowlineId);
                        nextLowline.setName(newLowlineName);
                        nextLowline.setParent(newLineId, newLineSubno);
                        this.lastLowline = nextLowline;
                    }
                }
            }
        });
    }

    public LineSide getLineSide(long lowlingId, LineUpDown upDown) {
        LineSide lineSide = null;
        Lowline busLine = this.getLowLine(lowlingId);
        if (busLine != null) {
            lineSide = busLine.getLineSide(upDown);
        }
        return lineSide;
    }

    public Lowline getLowLine(long lowlineId) {
        return this.lowlineMap.get(lowlineId);
    }
}

