/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.sgeo.gps;

import cn.gongler.util.sgeo.geo.GeoUtil;
import cn.gongler.util.sgeo.geo.IGeoPoint;
import cn.gongler.util.sgeo.geo.Scope;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class GeoRender {
    private static final long serialVersionUID = 1L;
    private final Set<Scope> scopes = new HashSet<Scope>();
    private final Map<Long, String> scopeNameMap = new HashMap<Long, String>();
    private final List<IGeoPoint> gpses = new ArrayList<IGeoPoint>();
    int oldX = 0;
    int oldY = 0;
    IGeoPoint oldGps = IGeoPoint.of(0.0, 0.0);
    private double jingduMin = 9999.0;
    private double weiduMin = 9999.0;
    private double jingduWidth = 0.0;
    private double weiduWidth = 0.0;
    private double jingduBili;
    private double weiduBili;
    private int width;
    private int height;

    public void draw(Scope scope, String name) {
        this.scopes.add(scope);
        this.scopeNameMap.put(scope.id(), name);
    }

    public void draw(IGeoPoint gps) {
        this.gpses.add(gps);
    }

    public BufferedImage render(int width, int height) {
        double jingduMin = 9999.0;
        double jingduMax = 0.0;
        double weiduMin = 9999.0;
        double weiduMax = 0.0;
        for (Scope scope : this.scopes) {
            for (IGeoPoint gps : scope) {
                jingduMin = Math.min(jingduMin, gps.gpsLng());
                jingduMax = Math.max(jingduMax, gps.gpsLng());
                weiduMin = Math.min(weiduMin, gps.gpsLat());
                weiduMax = Math.max(weiduMax, gps.gpsLat());
            }
        }
        for (IGeoPoint gps : this.gpses) {
            jingduMin = Math.min(jingduMin, gps.gpsLng());
            jingduMax = Math.max(jingduMax, gps.gpsLng());
            weiduMin = Math.min(weiduMin, gps.gpsLat());
            weiduMax = Math.max(weiduMax, gps.gpsLat());
        }
        this.setTranlate(jingduMin, weiduMin, jingduMax - jingduMin, weiduMax - weiduMin);
        this.setImgSize(width, height);
        int dis = (int)GeoUtil.GetDistance(jingduMin, weiduMin, jingduMax, weiduMax);
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D g2d = image.createGraphics();
        g2d.setBackground(Color.WHITE);
        g2d.clearRect(0, 0, width, height);
        g2d.setColor(Color.BLUE);
        g2d.drawString("dis: " + dis + "km", 0, 20);
        for (IGeoPoint gps : this.gpses) {
            this.drawLine(g2d, gps);
        }
        for (IGeoPoint gps : this.gpses) {
            this.drawPoint(g2d, gps);
        }
        for (Scope scope : this.scopes) {
            Polygon polygon = this.toPolygon(scope);
            g2d.setColor(Color.RED);
            g2d.drawPolygon(polygon);
            g2d.drawString(this.scopeNameMap.get(scope.id()), GeoRender.max(polygon.xpoints) + 4, GeoRender.max(polygon.ypoints) + 4);
        }
        return image;
    }

    private static int max(int[] vals) {
        int ret = 0;
        for (int val : vals) {
            ret = Math.max(val, ret);
        }
        return ret;
    }

    private static void SaveImg(BufferedImage image, Path pngFile) {
        try {
            ImageIO.write((RenderedImage)image, "png", pngFile.toFile());
        }
        catch (IOException ex) {
            Logger.getLogger(GeoRender.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void renderToFile(int width, int height, Path pngFile) {
        GeoRender.SaveImg(this.render(width, height), pngFile);
    }

    private void drawLine(Graphics2D g2d, IGeoPoint gps) {
        int x = this.getX(gps);
        int y = this.getY(gps);
        if (GeoUtil.GetDistance(this.oldGps, gps) < 1.0) {
            g2d.setColor(Color.GRAY);
            g2d.drawLine(x, y, this.oldX, this.oldY);
        }
        this.oldGps = gps;
        this.oldX = x;
        this.oldY = y;
    }

    private void drawPoint(Graphics2D g2d, IGeoPoint gps) {
        int x = this.getX(gps);
        int y = this.getY(gps);
        g2d.setColor(Color.BLACK);
        g2d.drawLine(x, y, x, y + 1);
    }

    private Polygon toPolygon(Scope scope) {
        Polygon polygon = new Polygon();
        Iterator<IGeoPoint> iterator = scope.iterator();
        for (IGeoPoint gps : scope) {
            int x = this.getX(gps);
            int y = this.getY(gps);
            polygon.addPoint(x, y);
        }
        return polygon;
    }

    private void setTranlate(double jingduMin, double weiduMin, double jingduWidth, double weiduWidth) {
        this.jingduMin = jingduMin;
        this.weiduMin = weiduMin;
        this.jingduWidth = jingduWidth;
        this.weiduWidth = weiduWidth;
    }

    int getX(IGeoPoint gps) {
        return (int)((gps.gpsLng() - this.jingduMin) * this.jingduBili);
    }

    int getY(IGeoPoint gps) {
        return (int)((gps.gpsLat() - this.weiduMin) * this.weiduBili);
    }

    private void setImgSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.jingduBili = (double)width / this.jingduWidth;
        this.weiduBili = (double)height / this.weiduWidth;
    }
}

