/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.sgeo.gps;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;

public class GPS20190406Util {
    private static final long serialVersionUID = 1L;
    public static final LocalDateTime DT1980_01_06_0800 = OffsetDateTime.parse("1980-01-06T00:00Z").atZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();

    private GPS20190406Util() {
    }

    public static LocalDateTime CorrectGpsTime(LocalDateTime org) {
        return GPS20190406Util.CorrectGpsTime(org, LocalDateTime.now());
    }

    public static LocalDateTime CorrectGpsTime(LocalDateTime org, LocalDateTime now) {
        long nowCircles;
        long orgCircles = Duration.between(DT1980_01_06_0800, org).toDays() / 7L / 1024L;
        if (orgCircles != (nowCircles = Duration.between(DT1980_01_06_0800, now).toDays() / 7L / 1024L) && Math.abs(Duration.between(org, now).toDays()) >= 3285L) {
            long deltaDays = (nowCircles - orgCircles) * 1024L * 7L;
            return org.plusDays(deltaDays);
        }
        return org;
    }
}

