/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.sgeo.geo;

import cn.gongler.util.sgeo.geo.IGeoPoint;
import java.awt.geom.Point2D;

interface XY {
    public double x();

    public double y();

    public static XY of(double x, double y) {
        return new Impl(x, y);
    }

    public static XY of(Point2D point) {
        return XY.of(point.getX(), point.getY());
    }

    public static XY of(IGeoPoint point) {
        return XY.of(point.gpsLng(), point.gpsLat());
    }

    public static class Impl
    implements XY {
        private static final long serialVersionUID = 1L;
        double x;
        double y;

        private Impl(double x, double y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public double x() {
            return this.x;
        }

        @Override
        public double y() {
            return this.y;
        }

        public String toString() {
            return "(" + this.x + "," + this.y + ")";
        }
    }
}

