/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.resend.db;

import cn.gongler.util.GonglerUtil;
import cn.gongler.util.function.ExceptionConsumer;
import cn.gongler.util.resend.ISender;
import cn.gongler.util.resend.Resender;
import java.io.Closeable;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;

public class SendPackScanner<Pack, Param, Ack>
implements Closeable {
    private static final long serialVersionUID = 1L;
    private final Resender<Pack, Param, Ack> busResender;
    private volatile boolean cancel = false;
    private int newPackHotPower;
    private Thread loaderThread;
    private long sleepMillns = 200L;
    private final Object loadDelayLock = new Object();

    public Resender<Pack, Param, Ack> ref() {
        return this.busResender;
    }

    public SendPackScanner(Runnable initPackChecker, ExceptionConsumer<ISendPackRegister<Pack, Param>> packScanner, BiPredicate<Pack, Ack> ackChecker, ISender<Pack> realSender) {
        this.busResender = new Resender(ackChecker, realSender);
        GonglerUtil.StartDaemonThread("dbloaderThread", () -> {
            if (initPackChecker != null) {
                initPackChecker.run();
            }
            ISendPackRegister<Object, Object> sendPackRegister = (busId, pack, expiredTime, waitAck, param) -> {
                this.busResender.add(busId, pack, expiredTime, waitAck, param);
                ++this.newPackHotPower;
            };
            while (!this.cancel) {
                try {
                    this.newPackHotPower /= 2;
                    packScanner.accept(sendPackRegister);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(this.sleepMillns);
                    if (this.newPackHotPower != 0) continue;
                    Object e = this.loadDelayLock;
                    synchronized (e) {
                        this.loadDelayLock.wait(1000L);
                    }
                }
                catch (InterruptedException ex) {
                    this.cancel = true;
                    ex.printStackTrace();
                }
            }
        });
    }

    public void ack(Long busId, Ack ackPack) {
        this.busResender.ack(busId, ackPack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyRecheck() {
        Object object = this.loadDelayLock;
        synchronized (object) {
            this.loadDelayLock.notify();
        }
    }

    public Resender<Pack, Param, Ack> busResender() {
        return this.busResender;
    }

    @Override
    public void close() throws IOException {
        this.cancel = true;
        this.loaderThread.interrupt();
        this.busResender.close();
    }

    public static void main(String[] args) {
    }

    public static interface ISendPackRegister<Pack, Param> {
        public void add(Long var1, Pack var2, LocalDateTime var3, boolean var4, Param var5);
    }
}

