/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.protocol.itemtype;

import cn.gongler.util.bytes.BytesBuilder;
import cn.gongler.util.bytes.BytesLoader;
import cn.gongler.util.protocol.itemtype.Item;
import cn.gongler.util.protocol.itemtype.ItemType;
import cn.gongler.util.protocol.itemtype.IteratorBuilder;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class ParamMapType
extends ItemType<ParamMapType> {
    private static final long serialVersionUID = 1L;
    protected final Map<Long, ItemType> paramTypeMap = new TreeMap<Long, ItemType>();
    int headerBytes = 1;
    int KeyBytes = 1;
    static final Map<Long, Item> INIT_VAL = Collections.EMPTY_MAP;

    public Map<Long, String> toNameMap() {
        return this.paramTypeMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, a -> ((ItemType)a.getValue()).name()));
    }

    public ParamMapType headerSize(int headerSize) {
        this.headerBytes = headerSize;
        return this;
    }

    public ParamMapType(int keyBytes, String name) {
        super(name);
        this.KeyBytes = keyBytes;
    }

    public ParamMapType add(long key, ItemType itemType) {
        ItemType old = this.paramTypeMap.put(key, itemType);
        if (old != null) {
            throw new IllegalArgumentException("ParamMapType.key " + key + " has repeated:");
        }
        return this;
    }

    @Override
    public Item create() {
        TreeMap params = new TreeMap();
        return this._newItem(params);
    }

    ItemType paramType(long key) {
        return this.paramTypeMap.get(key);
    }

    private Map<Long, Item> _newValue() {
        return new TreeMap<Long, Item>();
    }

    @Override
    public Item load(Scanner in) {
        int paramsSize = this.headerBytes == 0 ? Integer.MAX_VALUE : in.nextInt();
        Map<Long, Item> params = this._newValue();
        for (int i = 0; this.headerBytes > 0 && i < paramsSize || this.headerBytes == 0 && in.hasNext(); ++i) {
            long key = in.nextLong();
            ItemType paramType = this.paramTypeMap.get(key);
            if (paramType == null) {
                throw new IllegalArgumentException("Unknown Map.Key:" + key);
            }
            Item paramItem = paramType.load(in);
            params.put(key, paramItem);
        }
        return this._newItem(params);
    }

    @Override
    public Item load(Iterator<Object> in) {
        int paramsSize = this.headerBytes == 0 ? Integer.MAX_VALUE : ((Number)in.next()).intValue();
        Map<Long, Item> params = this._newValue();
        for (int i = 0; this.headerBytes > 0 && i < paramsSize || this.headerBytes == 0 && in.hasNext(); ++i) {
            long key = ((Number)in.next()).longValue();
            ItemType paramType = this.paramTypeMap.get(key);
            if (paramType == null) {
                throw new IllegalArgumentException("Unknown Map.Key:" + key);
            }
            Item paramItem = paramType.load(in);
            params.put(key, paramItem);
        }
        return this._newItem(params);
    }

    @Override
    public Item load(BytesLoader in) {
        int paramsSize = this.headerBytes == 0 ? Integer.MAX_VALUE : in.loadUnsignedByte();
        Map<Long, Item> params = this._newValue();
        for (int i = 0; this.headerBytes > 0 && i < paramsSize || this.headerBytes == 0 && in.remainBytesCount() > 0; ++i) {
            long key = in.loadLong(this.KeyBytes);
            BytesLoader valueReader = in.loadBytesReader(-1);
            ItemType paramType = this.paramTypeMap.computeIfAbsent(key, k -> ParamMapType.BYTES(valueReader.remainBytesCount(), "unknownKey" + k));
            Item paramItem = paramType.load(valueReader);
            params.put(key, paramItem);
        }
        return this._newItem(params);
    }

    @Override
    public void toBytes(Object itemValue, BytesBuilder build) {
        if (itemValue instanceof Map) {
            Map params = (Map)itemValue;
            int itemSize = params.size();
            build.addNum(this.headerBytes, (long)itemSize);
            params.forEach((k, v) -> {
                build.addNum(this.KeyBytes, (Long)k);
                BytesBuilder valBuild = BytesBuilder.of();
                this.paramType((long)k).toBytes((Item)v, valBuild);
                byte[] valBytes = valBuild.toBytes();
                build.addByte(valBytes.length);
                build.addBytes(valBytes);
            });
        }
    }

    @Override
    public void toFlatObject(Object itemValue, IteratorBuilder<Object> build) {
        Item item = (Item)itemValue;
        Map<Long, Item> map = item.mapValue();
        build.add((Object)map.size());
        map.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> build.add(entry.getKey()).add(entry.getValue()));
    }

    @Override
    protected Class insideValueClass() {
        return Map.class;
    }

    public String keyName(long key) {
        String hex = Long.toHexString(key);
        ItemType paramType = this.paramTypeMap.get(key);
        return paramType != null ? paramType.name() + "(0x" + hex + ")" : "key_0x" + hex;
    }

    @Override
    public String toString(Object itemValue) {
        if (itemValue != null) {
            Map params = (Map)itemValue;
            return params.entrySet().stream().map(e -> this.keyName((Long)e.getKey()) + ":" + e.getValue()).collect(Collectors.joining(",", "{", "}"));
        }
        return "null";
    }

    @Override
    public int dbParamCount() {
        return 1;
    }

    @Override
    public int statementParamImpl(Item item, CallableStatement statement, int pos) throws SQLException {
        statement.setString(pos++, item.formatFlatObjects());
        return 1;
    }

    @Override
    public List<? extends ItemType> flatItemTypes() {
        return Collections.singletonList(ParamMapType.STR(0, "\u952e\u503c\u5217\u8868"));
    }

    @Override
    protected Item getSubitemImpl(Item map, int key) {
        Map mapItem = (Map)map.getValue();
        Item subItem = mapItem.computeIfAbsent(Long.valueOf(key), k -> this.paramTypeMap.getOrDefault(k, ParamMapType.REMAIN_BYTES("\u672a\u77e5\u53c2\u6570")).create());
        return subItem;
    }

    @Override
    protected void addSubitemImpl(Item item, Object subitemValue) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

