/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.protocol.itemtype;

import cn.gongler.util.bytes.BytesBuilder;
import cn.gongler.util.bytes.BytesLoader;
import cn.gongler.util.protocol.itemtype.Item;
import cn.gongler.util.protocol.itemtype.ItemType;
import cn.gongler.util.protocol.itemtype.IteratorBuilder;
import cn.gongler.util.protocol.itemtype.ListItemType;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.stream.Collectors;

public class ItemTypeStruct
extends ItemType<ItemTypeStruct> {
    private static final long serialVersionUID = 1L;
    public final ItemType[] itemTypes;

    public ItemTypeStruct(String name, ItemType ... itemTypes) {
        super(name);
        this.itemTypes = itemTypes;
    }

    private Item[] _newValue() {
        return new Item[this.itemTypes.length];
    }

    @Override
    public Item load(BytesLoader in) {
        Item[] items = this._newValue();
        for (int i = 0; i < this.itemTypes.length; ++i) {
            items[i] = this.itemTypes[i].load(in);
        }
        return this._newItem(items);
    }

    @Override
    public Item load(Scanner in) {
        Item[] items = this._newValue();
        for (int i = 0; i < this.itemTypes.length; ++i) {
            items[i] = this.itemTypes[i].load(in);
        }
        return this._newItem(items);
    }

    @Override
    public Item load(Iterator<Object> in) {
        Item[] items = this._newValue();
        for (int i = 0; i < this.itemTypes.length; ++i) {
            items[i] = this.itemTypes[i].load(in);
        }
        return this._newItem(items);
    }

    @Override
    public void toBytes(Object itemValue, BytesBuilder build) {
        if (itemValue instanceof Item[]) {
            Item[] items = (Item[])itemValue;
            for (int i = 0; i < this.itemTypes.length; ++i) {
                this.itemTypes[i].toBytes(items[i], build);
            }
        }
    }

    @Override
    public int statementParamImpl(Item item, CallableStatement statement, int pos) throws SQLException {
        int beginPos = pos;
        Object itemValue = item.getValue();
        if (itemValue instanceof Item[]) {
            for (Item subitem : (Item[])itemValue) {
                pos += subitem.statementParam(statement, pos);
            }
        }
        return pos - beginPos;
    }

    @Override
    public void toFlatObject(Object itemValue, IteratorBuilder<Object> build) {
        if (itemValue instanceof Item[]) {
            for (Item subitem : (Item[])itemValue) {
                subitem.toFlatObject(build);
            }
        }
    }

    @Override
    public Item create() {
        Item[] items = new Item[this.itemTypes.length];
        for (int i = 0; i < this.itemTypes.length; ++i) {
            items[i] = this.itemTypes[i].create();
        }
        return this._newItem(items);
    }

    @Override
    public String toString(Object itemValue) {
        if (itemValue != null) {
            Item[] items = (Item[])itemValue;
            return Arrays.stream(items).map(item -> item.itemType().name() + ":" + item).collect(Collectors.joining(",", "{", "}"));
        }
        return "null";
    }

    @Override
    protected Class insideValueClass() {
        return Item[].class;
    }

    @Override
    public int dbParamCount() {
        int sum = Arrays.stream(this.itemTypes).mapToInt(ItemType::dbParamCount).sum();
        return sum;
    }

    @Override
    public List<ItemType> flatItemTypes() {
        ArrayList<ItemType> ret = new ArrayList<ItemType>();
        ret.addAll(Arrays.asList(this.itemTypes));
        return ret;
    }

    public ItemType get(int index) {
        return this.itemTypes[index];
    }

    public ItemType get(String subItemTypeName) {
        for (ItemType type : this.itemTypes) {
            if (!type.name().equalsIgnoreCase(subItemTypeName)) continue;
            return type;
        }
        throw new IllegalArgumentException("No exist: " + subItemTypeName);
    }

    protected Item[] itemValue(Item item) {
        return (Item[])item.getValue();
    }

    @Override
    protected Item getSubitemImpl(Item item, int key) {
        return this.itemValue(item)[key];
    }

    @Override
    protected void addSubitemImpl(Item item, Object subitemValue) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static class ListTypeOfTable4
    extends ListItemType {
        public ListTypeOfTable4(String name, ItemType subItemType) {
            super(name, subItemType);
        }

        @Override
        public Item load(Scanner in) {
            int vsize = in.nextInt();
            int asize = in.nextInt();
            int size = vsize + asize;
            List<Item> groups = this._newValue();
            for (int i = 0; i < size; ++i) {
                groups.add(this.subItemType.load(in));
            }
            return this._newItem(groups);
        }

        @Override
        public Item load(BytesLoader in) {
            int vsize = in.loadUnsignedByte();
            int asize = in.loadUnsignedByte();
            int len = vsize + asize;
            List<Item> groups = this._newValue();
            for (int i = 0; i < len; ++i) {
                groups.add(this.subItemType.load(in));
            }
            return this._newItem(groups);
        }

        @Override
        public Item load(Iterator<Object> in) {
            int vsize = ((Number)in.next()).intValue();
            int asize = ((Number)in.next()).intValue();
            int len = vsize + asize;
            List<Item> groups = this._newValue();
            for (int i = 0; i < len; ++i) {
                Item subItem = this.subItemType.load(in);
                groups.add(subItem);
            }
            return this._newItem(groups);
        }

        @Override
        public void toBytes(Object itemValue, BytesBuilder build) {
        }
    }
}

