/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.protocol.itemtype;

import cn.gongler.util.bytes.BytesBuilder;
import cn.gongler.util.bytes.BytesLoader;
import cn.gongler.util.protocol.itemtype.Item;
import cn.gongler.util.protocol.itemtype.NumberItemType;

public class ComplementSignedNumberItemType
extends NumberItemType {
    private static final long serialVersionUID = 1L;
    final long flagMask;
    final long valMask;
    final long valAllMask;

    public ComplementSignedNumberItemType(int bytes, String name) {
        this(bytes, 0, name);
    }

    public ComplementSignedNumberItemType(int bytes, int bits, String name) {
        super(bytes, bits, name);
        if (this.bits() == 0) {
            this.flagMask = 1 << this.bytes() * 8 - 1;
            long valM = 0L;
            for (int i = 0; i < bytes; ++i) {
                valM <<= 8;
                valM |= 0xFFL;
            }
            this.valAllMask = valM;
            this.valMask = valM ^= this.flagMask;
        } else {
            this.flagMask = 1 << this.allBits() - 1;
            long valM = 0L;
            for (int i = 0; i < this.allBits(); ++i) {
                valM <<= 1;
                valM |= 1L;
            }
            this.valAllMask = valM;
            this.valMask = valM ^= this.flagMask;
        }
    }

    private long decodeValue(long val) {
        boolean minus;
        boolean bl = minus = ((val &= this.valAllMask) & this.flagMask) != 0L;
        if (minus) {
            return -((val ^ this.valAllMask) + 1L);
        }
        return val & this.valAllMask;
    }

    private long encodeValue(long val) {
        return val;
    }

    @Override
    public Item load(BytesLoader in) {
        Item item = super.load(in);
        item.setValue(this.decodeValue(item.longValue()));
        return item;
    }

    @Override
    public void toBytes(Object itemValue, BytesBuilder out) {
        long val = this.encodeValue(this.objectToLong(itemValue));
        super.toBytes(val, out);
    }
}

