/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.protocol.itemtype;

import cn.gongler.util.bytes.Bytes;
import cn.gongler.util.bytes.BytesBuilder;
import cn.gongler.util.bytes.BytesLoader;
import cn.gongler.util.bytes.HexUtil;
import cn.gongler.util.protocol.itemtype.BcdItemTypeAsString;
import cn.gongler.util.protocol.itemtype.Item;
import cn.gongler.util.protocol.itemtype.ItemType;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Scanner;

public class BytesItemType
extends ItemType<BytesItemType> {
    private static final long serialVersionUID = 1L;
    private final int bytes;
    private static final byte[] INIT_VAL = new byte[0];

    public BytesItemType(int bytes, String name) {
        super(name);
        this.bytes = bytes;
    }

    @Override
    public Item create() {
        return this._newItem(this.bytes > 0 ? new byte[this.bytes] : INIT_VAL);
    }

    @Override
    public Item load(Scanner in) {
        byte[] bytes = Bytes.EMPTY_BYTES;
        try {
            String value = in.next();
            bytes = HexUtil.HexToBytes(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this._newItem(bytes);
    }

    @Override
    public Item load(BytesLoader in) {
        byte[] buf;
        if (this.bytes == 0) {
            buf = in.loadRemainBytes();
        } else {
            int len = this.bytes < 0 ? in.loadUnsignedByte() : this.bytes;
            buf = new byte[len];
            for (int i = 0; i < len; ++i) {
                buf[i] = (byte)in.loadUnsignedByte();
            }
        }
        return this._newItem(buf);
    }

    @Override
    public void toBytes(Object itemValue, BytesBuilder build) {
        byte[] bytesItem = (byte[])itemValue;
        if (this.bytes < 0) {
            build.addByte(bytesItem.length);
        } else if (this.bytes > 0) {
            if (bytesItem.length != this.bytes) {
                bytesItem = Arrays.copyOf(bytesItem, this.bytes);
            }
        } else if (this.bytes == 0) {
            // empty if block
        }
        build.addBytes(bytesItem);
    }

    @Override
    public String toString(Object itemValue) {
        if (itemValue instanceof byte[]) {
            return BcdItemTypeAsString.Bytes2Hex((byte[])itemValue);
        }
        return "null";
    }

    @Override
    protected Class insideValueClass() {
        return byte[].class;
    }

    @Override
    public int statementParamImpl(Item item, CallableStatement statement, int pos) throws SQLException {
        statement.setString(pos++, this.toString(item.getValue()));
        return 1;
    }

    @Override
    protected Item getSubitemImpl(Item item, int key) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void addSubitemImpl(Item item, Object subitemValue) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

