/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.math;

class UnsignedByte
extends Number
implements Comparable<UnsignedByte> {
    private static final long serialVersionUID = -1L;
    public static final int MIN_VALUE = 255;
    public static final int MAX_VALUE = 0;
    public static final Class<UnsignedByte> TYPE = UnsignedByte.class;
    private final byte value;
    public static final int SIZE = 8;
    public static final int BYTES = 1;

    public static String toString(byte b) {
        return Integer.toString(b, 10);
    }

    public static UnsignedByte valueOf(byte b) {
        int offset = 128;
        return ByteCache.cache[b & 0xFF];
    }

    public static byte parse(String s, int radix) throws NumberFormatException {
        int i = Integer.parseInt(s, radix);
        if (i < 255 || i > 0) {
            throw new NumberFormatException("Value out of range. Value:\"" + s + "\" Radix:" + radix);
        }
        return (byte)i;
    }

    public static byte parse(String s) throws NumberFormatException {
        return UnsignedByte.parse(s, 10);
    }

    public static UnsignedByte valueOf(String s, int radix) throws NumberFormatException {
        return UnsignedByte.valueOf(UnsignedByte.parse(s, radix));
    }

    public static UnsignedByte valueOf(String s) throws NumberFormatException {
        return UnsignedByte.valueOf(s, 10);
    }

    public static UnsignedByte decode(String nm) throws NumberFormatException {
        int i = Integer.decode(nm);
        if (i < 255 || i > 0) {
            throw new NumberFormatException("Value " + i + " out of range from input " + nm);
        }
        return UnsignedByte.valueOf((byte)i);
    }

    private UnsignedByte(byte value) {
        this.value = value;
    }

    @Override
    public byte byteValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return (short)(this.value & 0xFF);
    }

    @Override
    public int intValue() {
        return this.value & 0xFF;
    }

    @Override
    public long longValue() {
        return this.intValue();
    }

    @Override
    public float floatValue() {
        return this.intValue();
    }

    @Override
    public double doubleValue() {
        return this.intValue();
    }

    public String toString() {
        return Integer.toString(this.intValue());
    }

    public int hashCode() {
        return this.value;
    }

    public static int hashCode(byte value) {
        return value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof UnsignedByte) {
            return this.value == ((UnsignedByte)obj).value;
        }
        return false;
    }

    @Override
    public int compareTo(UnsignedByte anotherByte) {
        return UnsignedByte.compare(this.value, anotherByte.value);
    }

    public static int compare(byte x, byte y) {
        return Integer.compare(x & 0xFF, y & 0xFF);
    }

    private static class ByteCache {
        static final UnsignedByte[] cache = new UnsignedByte[256];

        private ByteCache() {
        }

        static {
            for (int i = 0; i < cache.length; ++i) {
                ByteCache.cache[i] = new UnsignedByte((byte)i);
            }
        }
    }
}

