/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

public class RingBytesOutputStream
extends FilterOutputStream {
    private static final long serialVersionUID = 1L;
    private final byte[] buf;
    private final AtomicInteger writePos = new AtomicInteger(0);
    private final int capacity;
    private final int capacityAlign;
    private final int mask;
    private static final OutputStream NULL_OUTPUT_STREAM = new OutputStream(){

        @Override
        public void write(int b) throws IOException {
        }
    };

    public RingBytesOutputStream() {
        this(null);
    }

    public RingBytesOutputStream(OutputStream out) {
        this(out, 0x100000);
    }

    public RingBytesOutputStream(OutputStream out, int capacity) {
        super(out == null ? NULL_OUTPUT_STREAM : out);
        this.capacity = capacity;
        this.capacityAlign = RingBytesOutputStream.AlignCapacity(capacity);
        this.mask = this.capacityAlign - 1;
        this.buf = new byte[this.capacityAlign];
        Arrays.fill(this.buf, (byte)32);
    }

    @Override
    public void write(int e) throws IOException {
        this.buf[this.wrapIndex((int)this.writePos.getAndIncrement())] = (byte)e;
        this.out.write(e);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int pos = this.wrapIndex(this.writePos.getAndAdd(len));
        int firstCopySize = Math.min(len, this.buf.length - pos);
        System.arraycopy(b, off, this.buf, pos, firstCopySize);
        int remainSize = len - firstCopySize;
        if (remainSize > 0) {
            System.arraycopy(b, off + firstCopySize, this.buf, 0, Math.min(remainSize, this.buf.length));
        }
        this.out.write(b, off, len);
    }

    private int wrapIndex(int serial) {
        return this.mask == 0 ? 0 : serial & this.mask;
    }

    private int currentIndex() {
        return this.wrapIndex(this.writePos.get());
    }

    public byte[] toBytes() {
        return RingBytesOutputStream.RingBufferToBytes(this.buf, this.currentIndex());
    }

    public byte[] toBytes(int lastLines) {
        byte[] bytes = this.toBytes();
        int line = 0;
        int pos = 0;
        for (int i = bytes.length - 1; i >= 0 && bytes[i] != 0; --i) {
            if (bytes[i] != 10) continue;
            pos = i + 1;
            if (++line == lastLines) break;
        }
        return Arrays.copyOfRange(bytes, pos, bytes.length);
    }

    private static byte[] RingBufferToBytes(byte[] buf, int pos) {
        long from = System.nanoTime();
        byte[] tmp = (byte[])buf.clone();
        byte[] ret = new byte[tmp.length];
        System.arraycopy(tmp, pos, ret, 0, tmp.length - pos);
        System.arraycopy(tmp, 0, ret, tmp.length - pos, pos);
        long to = System.nanoTime();
        return ret;
    }

    private static int AlignCapacity(int anyCapacity) {
        if (anyCapacity <= 1) {
            return 1;
        }
        return 1 << RingBytesOutputStream.HighBitIndex(anyCapacity - 1) + 1;
    }

    private static int HighBitIndex(int val) {
        for (int i = 0; i < 32; ++i) {
            int moveBitCnt = 31 - i;
            if ((val >>> moveBitCnt & 1) != 1) continue;
            return moveBitCnt;
        }
        return 1;
    }
}

