/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IoUtil {
    private static final long serialVersionUID = 1L;
    private static final int BUFFER_SIZE = 8192;

    private IoUtil() {
    }

    public static long ReadAllBytes(InputStream source, OutputStream sink) throws IOException {
        int n;
        if (!BufferedOutputStream.class.isInstance(sink)) {
            sink = new BufferedOutputStream(sink);
        }
        byte[] buf = new byte[8192];
        long nread = 0L;
        while ((n = source.read(buf)) > 0) {
            sink.write(buf, 0, n);
            nread += (long)n;
        }
        return nread;
    }

    public static byte[] ReadAllBytes(InputStream in) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            if (!BufferedInputStream.class.isInstance(in)) {
                in = new BufferedInputStream(in);
            }
            IoUtil.ReadAllBytes(in, out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }
}

