/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.io;

import cn.gongler.util.bytes.BytesBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class HexOutputStream
extends OutputStream {
    private static final long serialVersionUID = -1L;
    public static final int DEFAULT_LINE_WIDTH = 16;
    private final Writer hexWriter;
    private int lineWidth = 16;
    private boolean includeBlankchar = false;
    private int columnCnt = 0;
    private int lineCnt = 0;
    private long lineBytePos = 0L;
    private final BytesBuilder cache = BytesBuilder.of();

    public HexOutputStream(Writer hexWriter) {
        this.hexWriter = new BufferedWriter(hexWriter);
    }

    public HexOutputStream(File hexFile) throws IOException {
        this.hexWriter = new BufferedWriter(new FileWriter(hexFile));
    }

    public HexOutputStream lineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
        return this;
    }

    public HexOutputStream blankChar(boolean includeBlankChar) {
        this.includeBlankchar = includeBlankChar;
        return this;
    }

    @Override
    public void write(int b) throws IOException {
        this.writeHalfByte(b >>> 4);
        this.writeHalfByte(b);
        this.cache.addByte(b);
        if (this.includeBlankchar) {
            this.hexWriter.write(32);
        }
        ++this.columnCnt;
        if (this.columnCnt == this.lineWidth) {
            this.newLine();
        }
    }

    public void newLine() throws IOException {
        if (this.columnCnt > 0) {
            this.hexWriter.append("#L").append(String.valueOf(++this.lineCnt)).append(", ").append(Long.toHexString(this.lineBytePos)).append("(").append(String.valueOf(this.lineBytePos)).append(")").append(" ").append(HexOutputStream.byteChars(this.cache.toBytes()));
            this.lineBytePos += (long)this.columnCnt;
            this.columnCnt = 0;
            this.hexWriter.write(13);
            this.hexWriter.write(10);
        }
    }

    private static String byteChars(byte[] bytes) {
        StringBuilder buf = new StringBuilder();
        for (byte b : bytes) {
            char ch = (char)(b & 0xFF);
            buf.append(ch >= ' ' && ch <= '~' ? Character.valueOf(ch) : ".");
        }
        return buf.toString();
    }

    private static char HexValToAsc(int halfByte) throws IOException {
        char[] table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        return table[halfByte & 0xF];
    }

    private void writeHalfByte(int halfByte) throws IOException {
        this.hexWriter.write(HexOutputStream.HexValToAsc(halfByte));
    }

    @Override
    public void close() throws IOException {
        if (this.hexWriter != null) {
            this.hexWriter.close();
        }
    }
}

