/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class HexInputStream
extends InputStream {
    private static final long serialVersionUID = -1L;
    private final Reader reader;

    public HexInputStream(File file) throws FileNotFoundException {
        this(new FileReader(file));
    }

    public HexInputStream(File file, String charset) throws FileNotFoundException, UnsupportedEncodingException {
        this(new InputStreamReader((InputStream)new FileInputStream(file), charset));
    }

    public HexInputStream(Reader reader) {
        this.reader = reader;
    }

    private static boolean isHexChar(int ch) {
        return ch >= 48 && ch <= 57 || ch >= 97 && ch <= 102 || ch >= 65 && ch <= 70;
    }

    private static boolean reachLineEnd(int ch) {
        return ch == 10 || ch == -1;
    }

    private void skitToLineEnd() throws IOException {
        while (!HexInputStream.reachLineEnd(this.reader.read())) {
        }
    }

    private static int HexAscToVal(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u7b26\u5408[0-9A-Fa-f]");
    }

    private int nextHalfByte() throws IOException {
        int byteVal;
        while ((byteVal = this.reader.read()) > 0) {
            if (Character.isWhitespace(byteVal)) continue;
            if (byteVal == 35) {
                this.skitToLineEnd();
                continue;
            }
            if (HexInputStream.isHexChar(byteVal)) {
                int halfByte = HexInputStream.HexAscToVal((char)byteVal);
                return halfByte & 0xF;
            }
            System.out.println("Exception: \u975e\u6cd5\u7b26\u53f7\uff1a" + (char)byteVal + ",code=" + byteVal);
        }
        return byteVal;
    }

    @Override
    public int read() throws IOException {
        int hi = this.nextHalfByte();
        int lo = this.nextHalfByte();
        if (hi != -1 && lo == -1) {
            throw new IOException("\u6587\u4ef6\u7ed3\u5c3e\u5269\u4e0b\u534a\u4e2a\u5b57\u8282\uff1a" + (char)hi + ",code=" + hi);
        }
        if (hi == -1 || lo == -1) {
            return -1;
        }
        return hi << 4 | lo;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int c;
        int i;
        for (i = 0; i < len && (c = this.read()) != -1; ++i) {
            b[off + i] = (byte)c;
        }
        return i;
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }
}

