/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.function;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

@FunctionalInterface
public interface TriPredicate<T, U, W> {
    public boolean test(T var1, U var2, W var3);

    default public TriPredicate<T, U, W> and(TriPredicate<? super T, ? super U, ? super W> other) {
        Objects.requireNonNull(other);
        return (t, u, w) -> this.test(t, u, w) && other.test(t, u, w);
    }

    default public TriPredicate<T, U, W> and(BiPredicate<? super T, ? super U> other) {
        Objects.requireNonNull(other);
        return (t, u, w) -> this.test(t, u, w) && other.test(t, u);
    }

    default public TriPredicate<T, U, W> and(Predicate<? super T> other) {
        Objects.requireNonNull(other);
        return (t, u, w) -> this.test(t, u, w) && other.test(t);
    }

    default public TriPredicate<T, U, W> negate() {
        return (t, u, w) -> !this.test(t, u, w);
    }

    default public TriPredicate<T, U, W> or(TriPredicate<? super T, ? super U, ? super W> other) {
        Objects.requireNonNull(other);
        return (t, u, w) -> this.test(t, u, w) || other.test(t, u, w);
    }

    default public TriPredicate<T, U, W> or(BiPredicate<? super T, ? super U> other) {
        Objects.requireNonNull(other);
        return (t, u, w) -> this.test(t, u, w) || other.test(t, u);
    }

    default public TriPredicate<T, U, W> or(Predicate<? super T> other) {
        Objects.requireNonNull(other);
        return (t, u, w) -> this.test(t, u, w) || other.test(t);
    }
}

