/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.db;

import cn.gongler.util.db.ConnectionFactory;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;

class DataSourceAdapter
implements DataSource,
ConnectionFactory {
    private static final long serialVersionUID = 2488330094927178570L;
    final ConnectionFactory connectionFactory;
    PrintWriter logWriter = new PrintWriter(System.out);
    private int timeoutSeconds;

    public static DataSource of(String url, String username, String password) {
        return new DataSourceAdapter(ConnectionFactory.of(url, url, password));
    }

    public static DataSource of(ConnectionFactory connectionFactory) {
        return new DataSourceAdapter(connectionFactory);
    }

    public DataSourceAdapter(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connectionFactory.getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.logWriter = out;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.timeoutSeconds = seconds;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.timeoutSeconds;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }
}

