/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.concurrent;

import cn.gongler.util.GonglerUtil;
import cn.gongler.util.concurrent.ConcurrentBusExecutor;
import cn.gongler.util.db.ConnectionFactory;
import cn.gongler.util.db.IDbTask;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import java.util.function.Consumer;
import javax.sql.DataSource;

public class ConcurrentBusDbExecutor
extends ConcurrentBusExecutor {
    private static final long serialVersionUID = 3106825658808470874L;
    private final ConnectionFactory connectionFactory;
    private Consumer<SQLException> sqlExceptionHandler = e -> {};
    private long milliseconds = Duration.ofMinutes(10L).toMillis();

    public ConcurrentBusDbExecutor(int nThread, ConnectionFactory connectionFactory) {
        super(nThread);
        this.connectionFactory = connectionFactory;
    }

    public ConcurrentBusDbExecutor timeout(Duration timeout) {
        this.milliseconds = timeout.toMillis();
        return this;
    }

    private Connection withTimeout(Connection conn) {
        try {
            if ((long)conn.getNetworkTimeout() <= 0L) {
                conn.setNetworkTimeout(Runnable::run, (int)this.milliseconds);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return conn;
    }

    public ConcurrentBusDbExecutor(int nThread, DataSource dataSource) {
        this(nThread, dataSource::getConnection);
    }

    public ConcurrentBusDbExecutor sqlExceptionHandler(Consumer<SQLException> sqlExceptionHandler) {
        this.sqlExceptionHandler = sqlExceptionHandler;
        return this;
    }

    @Override
    public void accept(Long busKey, IDbTask dbTask) {
        this.accept(busKey, () -> {
            block14: {
                Connection conn2 = null;
                try (Connection conn = conn2 = this.connectionFactory.getConnection();){
                    dbTask.accessDb(this.withTimeout(conn));
                    conn.commit();
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    GonglerUtil.Rollback(conn2);
                    if (!(ex instanceof SQLException)) break block14;
                    GonglerUtil.ExecuteWithCatchAny(() -> this.sqlExceptionHandler.accept((SQLException)ex));
                }
            }
        });
    }
}

