/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.collection;

import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.stream.Collectors;

public interface IStack<E>
extends Iterable<E> {
    public E push(E var1);

    public E pop();

    public E peek();

    public int size();

    public List<E> asList();

    public static <E> IStack<E> of() {
        return IStack.of(new ConcurrentLinkedDeque());
    }

    public static <E> IStack<E> of(final Deque<E> from) {
        return new IStack<E>(){

            @Override
            public E pop() {
                return from.pop();
            }

            @Override
            public E push(E item) {
                from.push(item);
                return item;
            }

            @Override
            public E peek() {
                return from.peek();
            }

            @Override
            public int size() {
                return from.size();
            }

            @Override
            public List<E> asList() {
                return from.stream().collect(Collectors.toList());
            }

            @Override
            public Iterator<E> iterator() {
                return from.iterator();
            }

            public String toString() {
                return "IStack@" + this.hashCode() + "_" + this.peek() + "_size" + this.size();
            }
        };
    }
}

