/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.bytes;

import cn.gongler.util.GonglerUtil;
import cn.gongler.util.bytes.BitUtil;
import cn.gongler.util.bytes.function.ByteConsumer;
import java.util.List;

class BitsBuilder {
    private static final long serialVersionUID = 1L;
    private final ByteConsumer consumer;
    private byte bitBuf = 0;
    private int bitIndex = 7;

    public static BitsBuilder of(ByteConsumer consumer) {
        return new BitsBuilder(consumer);
    }

    protected BitsBuilder(ByteConsumer consumer) {
        this.consumer = consumer;
    }

    private byte bitBufIsFull() {
        byte ret = this.bitBuf;
        this.bitBuf = 0;
        this.bitIndex = 7;
        return ret;
    }

    public BitsBuilder addBit(boolean bitVal) {
        this.bitBuf = BitUtil.setBit(this.bitBuf, this.bitIndex--, bitVal);
        if (this.bitIndex < 0) {
            this.consumer.accept(this.bitBufIsFull());
        }
        return this;
    }

    public BitsBuilder addBitRepeat(boolean bitVal, int repeatTimes) {
        for (int i = 0; i < repeatTimes; ++i) {
            this.addBit(bitVal);
        }
        return this;
    }

    public BitsBuilder addBit(int bitVal) {
        GonglerUtil.require(bitVal == 0 || bitVal == 1, "\u975e\u6cd5\u503c" + bitVal);
        this.addBit(bitVal == 1);
        return this;
    }

    public BitsBuilder addBitRepeat(int bitVal, int repeatTimes) {
        for (int i = 0; i < repeatTimes; ++i) {
            this.addBit(bitVal);
        }
        return this;
    }

    public BitsBuilder addBits(int bitCnt, long bitsVal) {
        for (int i = 0; i < bitCnt; ++i) {
            this.addBit((bitsVal >>> bitCnt - 1 - i & 1L) == 1L);
        }
        return this;
    }

    public BitsBuilder addBits(CharSequence bitsStr) {
        GonglerUtil.require(bitsStr.toString().matches("[01]+"), "\u975e\u6cd5bit\u503c" + bitsStr);
        for (int i = 0; i < bitsStr.length(); ++i) {
            this.addBit(bitsStr.charAt(i) == '1');
        }
        return this;
    }

    public BitsBuilder addBits(List<Boolean> bits) {
        bits.forEach(this::addBit);
        return this;
    }

    public int remainBitCnt() {
        return 7 - this.bitIndex;
    }

    public BitsBuilder requireFinished() {
        GonglerUtil.require(this.remainBitCnt() == 0, "remain bits not enough to a byte:" + this.remainBitCnt());
        return this;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 7; i < this.bitIndex; --i) {
            buf.append(BitUtil.getBit(this.bitBuf, i) ? (char)'1' : '0');
        }
        return buf.toString();
    }
}

