/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.bytes;

import cn.gongler.util.GonglerUtil;
import cn.gongler.util.bytes.BitUtil;
import java.util.function.IntFunction;

public class Bits {
    private static final long serialVersionUID = 1L;
    long bits;
    int bitCnt;

    public static Bits of() {
        return Bits.of(0L);
    }

    public static Bits of(long val) {
        return new Bits(val, 64);
    }

    public static Bits ByteSize(int byteCnt) {
        return Bits.BitSize(byteCnt * 8);
    }

    public static Bits BitSize(int bitCnt) {
        return new Bits(0L, bitCnt);
    }

    public static Bits of(Long bits) {
        return Bits.of(GonglerUtil.WithDefault(bits, 0L)).byteSize(8);
    }

    public static Bits of(Integer bits) {
        return Bits.of(GonglerUtil.WithDefault(bits, 0)).byteSize(4);
    }

    public static Bits of(Short bits) {
        return Bits.of(GonglerUtil.WithDefault(bits, (short)0)).byteSize(2);
    }

    public static Bits of(Byte bits) {
        return Bits.of(GonglerUtil.WithDefault(bits, (byte)0)).byteSize(1);
    }

    public Bits(long bits, int bitCnt) {
        GonglerUtil.requireLessThenOrEqual(bitCnt, 64);
        this.bits = bits;
        this.bitCnt = bitCnt;
    }

    public Bits byteSize(int byteCnt) {
        GonglerUtil.requireLessThenOrEqual(byteCnt, 8);
        this.bitCnt = byteCnt * 8;
        return this;
    }

    public Bits bitSize(int bitCnt) {
        GonglerUtil.requireLessThenOrEqual(bitCnt, 64);
        this.bitCnt = bitCnt;
        return this;
    }

    public int bit(int bitIndex) {
        GonglerUtil.requireLessThenOrEqual(bitIndex, this.bitCnt);
        return BitUtil.getBit(this.bits, bitIndex) ? 1 : 0;
    }

    public Bits bit(int bitIndex, int bitValue) {
        GonglerUtil.requireLessThenOrEqual(bitIndex, this.bitCnt);
        this.bits = BitUtil.setBit(this.bits, bitIndex, bitValue != 0);
        return this;
    }

    public boolean bitBool(int bitIndex) {
        GonglerUtil.requireLessThenOrEqual(bitIndex, this.bitCnt);
        return BitUtil.getBit(this.bits, bitIndex);
    }

    public Bits bit(int bitIndex, boolean bitValue) {
        GonglerUtil.requireLessThenOrEqual(bitIndex, this.bitCnt);
        this.bits = BitUtil.setBit(this.bits, bitIndex, bitValue);
        return this;
    }

    public <T> T bit(int bitIndex, IntFunction<T> mapper) {
        return mapper.apply(this.bit(bitIndex));
    }

    public int bits(int bitIndex, int bitCnt) {
        GonglerUtil.requireLessThenOrEqual(bitIndex + bitCnt, this.bitCnt);
        return BitUtil.getBits(this.bits, bitIndex, bitCnt);
    }

    public <T> T bits(int bitIndex, int bitCnt, IntFunction<T> mapper) {
        return mapper.apply(this.bits(bitIndex, bitCnt));
    }

    public Bits bits(int bitIndex, int bitCnt, int bitValue) {
        GonglerUtil.requireLessThenOrEqual(bitIndex + bitCnt, this.bitCnt);
        this.bits = BitUtil.setBits(this.bits, bitIndex, bitCnt, bitValue);
        return this;
    }

    public Bits bits(int bitIndex, CharSequence binString) {
        int bitCnt = binString.length();
        int bitValue = Integer.valueOf(binString.toString(), 2);
        return this.bits(bitIndex, bitCnt, bitValue);
    }

    public String bitsString(int bitIndex, int bitCnt) {
        return this.toString(bitIndex, bitIndex + bitCnt);
    }

    public int fromTo(int lowBitIndex, int highBitIndexExclusive) {
        return this.bits(lowBitIndex, highBitIndexExclusive - lowBitIndex);
    }

    public Bits fromTo(int lowBitIndex, int highBitIndexExclusive, int value) {
        return this.bits(lowBitIndex, highBitIndexExclusive - lowBitIndex, value);
    }

    public <T> T fromTo(int lowBitIndex, int highBitIndexExclusive, IntFunction<T> mapper) {
        return this.bits(lowBitIndex, highBitIndexExclusive - lowBitIndex, mapper);
    }

    public String fromToString(int lowBitIndex, int highBitIndexExclusive) {
        return this.toString(lowBitIndex, highBitIndexExclusive);
    }

    public long toLong() {
        return this.bits;
    }

    public int toInt() {
        return (int)this.bits;
    }

    public short toShort() {
        return (short)this.bits;
    }

    public byte toByte() {
        return (byte)this.bits;
    }

    public String toString(int lowBitIndex, int highBitIndexExclusive) {
        GonglerUtil.requireLessThenOrEqual(highBitIndexExclusive, this.bitCnt);
        StringBuilder buf = new StringBuilder(this.bitCnt);
        for (int i = highBitIndexExclusive - 1; i >= lowBitIndex; --i) {
            buf.append(this.bit(i));
        }
        return buf.toString();
    }

    public String toString() {
        return this.toString(0, this.bitCnt);
    }
}

