/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util;

import cn.gongler.util.ITask;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class MinuteTimer
implements AutoCloseable {
    private static final long serialVersionUID = 1L;
    private final ScheduledExecutorService es = Executors.newSingleThreadScheduledExecutor();
    private final Set<ITask> tasks = new CopyOnWriteArraySet<ITask>();

    public static MinuteTimer of() {
        return new MinuteTimer();
    }

    private MinuteTimer() {
        this.es.scheduleAtFixedRate(() -> this.tasks.forEach(a -> a.executeWithCatchAny()), 1L, 1L, TimeUnit.MINUTES);
    }

    public MinuteTimer add(ITask task) {
        this.tasks.add(task);
        return this;
    }

    @Override
    public void close() throws Exception {
        this.es.shutdownNow();
    }
}

