/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util;

import cn.gongler.util.tuple.Tuple;
import cn.gongler.util.tuple.Tuple2;
import cn.gongler.util.tuple.Tuple3;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;

public class EqualsComparatorWithErrorCode<T> {
    private static final long serialVersionUID = 3395500877730237999L;
    private final Tuple2<T, Object> defaultCode;
    List<Tuple3<Boolean, T, Object>> list = new ArrayList<Tuple3<Boolean, T, Object>>();

    public static <U> EqualsComparatorWithErrorCode<U> of(U defaultCode) {
        return new EqualsComparatorWithErrorCode<U>(defaultCode);
    }

    public EqualsComparatorWithErrorCode(T defaultVal) {
        this.defaultCode = Tuple.of(defaultVal, null);
    }

    public EqualsComparatorWithErrorCode<T> compare(Object val, Object standardVal, T errCode) {
        return this.register(Objects.equals(val, standardVal), errCode, val);
    }

    public <L, R> EqualsComparatorWithErrorCode<T> compare(L val, R standardVal, BiFunction<L, R, Boolean> mapper, T errCode) {
        return this.register(mapper.apply(val, standardVal), errCode, val);
    }

    private EqualsComparatorWithErrorCode<T> register(Boolean b, T result, Object checkVal) {
        this.list.add(Tuple.of(b, result, checkVal));
        return this;
    }

    public Tuple2<T, Object> result() {
        for (Tuple3<Boolean, T, Object> tuple : this.list) {
            if (tuple.first().booleanValue()) continue;
            return Tuple.of(tuple.second(), tuple.third());
        }
        return this.defaultCode;
    }
}

