/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util;

import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

class ChineseLinenameComparator<T>
implements Comparator<T> {
    private static final long serialVersionUID = -1811684678923180894L;
    private static final ChineseLinenameComparator<String> DEFAULT_INSTANCE = new ChineseLinenameComparator(Function.identity());
    private final Function<T, String> toLinename;

    public static ChineseLinenameComparator of() {
        return DEFAULT_INSTANCE;
    }

    public static <T> ChineseLinenameComparator<T> of(Function<T, String> toLinename) {
        return new ChineseLinenameComparator<T>(toLinename);
    }

    private ChineseLinenameComparator(Function<T, String> toLinename) {
        this.toLinename = toLinename;
    }

    @Override
    public int compare(T o1, T o2) {
        LineParser t1 = new LineParser(this.toLinename.apply(o1));
        LineParser t2 = new LineParser(this.toLinename.apply(o2));
        ComparisonChain c = ComparisonChain.start().compareTrueFirst(t1.hasDigit(), t2.hasDigit()).compareTrueFirst(t1.leftIndex() < 0, t2.leftIndex() < 0);
        for (int i = Math.min(t1.leftIndex(), t2.leftIndex()); i <= Math.max(t1.rightIndex(), t2.rightIndex()); ++i) {
            c = c.compare(t1.get(i), t2.get(i));
        }
        return c.result();
    }

    private static abstract class ComparisonChain {
        private static final long serialVersionUID = 1L;
        private static final ComparisonChain ACTIVE = new ComparisonChain(){

            @Override
            public ComparisonChain compare(Comparable<?> left, Comparable<?> right) {
                return this.classify(left.compareTo(right));
            }

            @Override
            public <T> ComparisonChain compare(T left, T right, Comparator<T> comparator) {
                return this.classify(comparator.compare(left, right));
            }

            @Override
            public ComparisonChain compare(int left, int right) {
                return this.classify(Integer.compare(left, right));
            }

            @Override
            public ComparisonChain compare(long left, long right) {
                return this.classify(Long.compare(left, right));
            }

            @Override
            public ComparisonChain compare(float left, float right) {
                return this.classify(Float.compare(left, right));
            }

            @Override
            public ComparisonChain compare(double left, double right) {
                return this.classify(Double.compare(left, right));
            }

            @Override
            public ComparisonChain compareTrueFirst(boolean left, boolean right) {
                return this.classify(Boolean.compare(right, left));
            }

            @Override
            public ComparisonChain compareFalseFirst(boolean left, boolean right) {
                return this.classify(Boolean.compare(left, right));
            }

            private ComparisonChain classify(int result) {
                return result < 0 ? LESS : (result > 0 ? GREATER : ACTIVE);
            }

            @Override
            public int result() {
                return 0;
            }
        };
        private static final ComparisonChain LESS = new InactiveComparisonChain(-1);
        private static final ComparisonChain GREATER = new InactiveComparisonChain(1);

        private ComparisonChain() {
        }

        public static ComparisonChain start() {
            return ACTIVE;
        }

        public abstract ComparisonChain compare(Comparable<?> var1, Comparable<?> var2);

        public abstract <T> ComparisonChain compare(T var1, T var2, Comparator<T> var3);

        public abstract ComparisonChain compare(int var1, int var2);

        public abstract ComparisonChain compare(long var1, long var3);

        public abstract ComparisonChain compare(float var1, float var2);

        public abstract ComparisonChain compare(double var1, double var3);

        public abstract ComparisonChain compareTrueFirst(boolean var1, boolean var2);

        public abstract ComparisonChain compareFalseFirst(boolean var1, boolean var2);

        public abstract int result();

        private static final class InactiveComparisonChain
        extends ComparisonChain {
            final int result;

            InactiveComparisonChain(int result) {
                this.result = result;
            }

            @Override
            public ComparisonChain compare(Comparable<?> left, Comparable<?> right) {
                return this;
            }

            @Override
            public <T> ComparisonChain compare(T left, T right, Comparator<T> comparator) {
                return this;
            }

            @Override
            public ComparisonChain compare(int left, int right) {
                return this;
            }

            @Override
            public ComparisonChain compare(long left, long right) {
                return this;
            }

            @Override
            public ComparisonChain compare(float left, float right) {
                return this;
            }

            @Override
            public ComparisonChain compare(double left, double right) {
                return this;
            }

            @Override
            public ComparisonChain compareTrueFirst(boolean left, boolean right) {
                return this;
            }

            @Override
            public ComparisonChain compareFalseFirst(boolean left, boolean right) {
                return this;
            }

            @Override
            public int result() {
                return this.result;
            }
        }
    }

    private static class LineParser {
        private static final long serialVersionUID = 1L;
        private final List<Item> items = new LinkedList<Item>();
        private int indexOfLu = -1;
        private final String originalLineName;
        private final Map<Integer, Item> map = new HashMap<Integer, Item>();

        LineParser(String orginal) {
            this.originalLineName = orginal;
            boolean isDigit = true;
            StringBuilder itemBuf = new StringBuilder();
            for (char ch : orginal.toCharArray()) {
                if (itemBuf.length() == 0) {
                    itemBuf.append(LineParser.changeChineseDigit(ch));
                    isDigit = Character.isDigit(ch);
                    continue;
                }
                if (Character.isDigit(ch) != isDigit) {
                    this.items.add(new Item(itemBuf.toString()));
                    itemBuf.setLength(0);
                } else if (itemBuf.toString().endsWith("\u8def")) {
                    this.items.add(new Item(itemBuf.toString()));
                    itemBuf.setLength(0);
                }
                itemBuf.append(LineParser.changeChineseDigit(ch));
                isDigit = Character.isDigit(ch);
                if ('\u8def' != ch) continue;
                this.indexOfLu = this.items.size();
            }
            if (itemBuf.length() > 0) {
                this.items.add(new Item(itemBuf.toString()));
            }
            if (isDigit && this.indexOfLu == -1) {
                this.items.add(new Item("\u8def"));
                this.indexOfLu = this.items.size() - 1;
            }
            for (int i = 0; i < this.items.size(); ++i) {
                this.map.put(i - this.indexOfLu, this.items.get(i));
            }
        }

        Item get(int i) {
            return this.map.getOrDefault(i, Item.NULL);
        }

        int leftIndex() {
            return -this.indexOfLu;
        }

        int rightIndex() {
            return this.items.size() - 1 - this.indexOfLu;
        }

        boolean hasDigit() {
            for (char ch : this.originalLineName.toCharArray()) {
                if (!Character.isDigit(ch)) continue;
                return true;
            }
            return false;
        }

        int leftLength() {
            if (this.leftIndex() < 0) {
                return -this.leftIndex();
            }
            return 0;
        }

        int getLineNumber() {
            return this.get(-1) == null ? Integer.MAX_VALUE : this.get((int)-1).intVal;
        }

        private static char changeChineseDigit(char ch) {
            char ret;
            switch (ch) {
                case '\u4e00': {
                    ret = '1';
                    break;
                }
                case '\u4e8c': {
                    ret = '2';
                    break;
                }
                case '\u4e09': {
                    ret = '3';
                    break;
                }
                case '\u56db': {
                    ret = '4';
                    break;
                }
                case '\u4e94': {
                    ret = '5';
                    break;
                }
                case '\u516d': {
                    ret = '6';
                    break;
                }
                case '\u4e03': {
                    ret = '7';
                    break;
                }
                case '\u516b': {
                    ret = '8';
                    break;
                }
                case '\u4e5d': {
                    ret = '9';
                    break;
                }
                case '\u96f6': {
                    ret = '0';
                }
                case '\u5341': {
                    ret = 'A';
                }
                case '\u767e': {
                    ret = 'B';
                }
                case '\u5343': {
                    ret = 'C';
                    break;
                }
                default: {
                    ret = ch;
                }
            }
            return ret;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < this.items.size(); ++i) {
                buf.append("[").append(i - this.indexOfLu).append("]").append(this.items.get(i));
            }
            buf.append(" hasDigit:").append(this.hasDigit());
            buf.append(" LineNumber:").append(this.getLineNumber());
            buf.append(" leftLength():").append(this.leftLength());
            return buf.append(", ").append(this.leftIndex()).append("~").append(this.rightIndex()).toString();
        }

        static class Item
        implements Comparable<Item> {
            private static final long serialVersionUID = 1L;
            static Item NULL = new Item("0");
            int intVal = Integer.MAX_VALUE;
            String msgVal = "";

            Item(String str) {
                try {
                    this.intVal = Integer.parseInt(str, 10);
                }
                catch (Exception e) {
                    this.msgVal = str;
                }
            }

            @Override
            public int compareTo(Item o) {
                return ComparisonChain.start().compare(this.intVal, o.intVal).compare((Comparable<?>)((Object)this.msgVal), (Comparable<?>)((Object)o.msgVal)).result();
            }

            public String toString() {
                return "(" + this.intVal + "," + this.msgVal + ")";
            }
        }
    }
}

