/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.text;

import cn.gongler.util.bytes.HexUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;

public class StringLinker
implements CharSequence,
Serializable {
    private final String delimiter;
    private String prefix = "";
    private String suffix = "";
    private String defaultStringIfNull = null;
    private String emptyValue;
    private StringBuilder value;

    public static StringLinker of() {
        return new StringLinker("");
    }

    public static StringLinker of(CharSequence delimiter) {
        return new StringLinker(delimiter);
    }

    public static StringLinker of(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return new StringLinker(delimiter).wrapper(prefix, suffix);
    }

    public StringLinker(CharSequence delimiter) {
        Objects.requireNonNull(delimiter, "The delimiter must not be null");
        this.delimiter = delimiter.toString();
        this.emptyValue = this.prefix + this.suffix;
    }

    public StringLinker(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        Objects.requireNonNull(prefix, "The prefix must not be null");
        Objects.requireNonNull(delimiter, "The delimiter must not be null");
        Objects.requireNonNull(suffix, "The suffix must not be null");
        this.prefix = prefix.toString();
        this.delimiter = delimiter.toString();
        this.suffix = suffix.toString();
        this.emptyValue = this.prefix + this.suffix;
    }

    public StringLinker wrapper(CharSequence prefix, CharSequence suffix) {
        Objects.requireNonNull(prefix, "The prefix must not be null");
        Objects.requireNonNull(suffix, "The suffix must not be null");
        this.prefix = prefix.toString();
        this.suffix = suffix.toString();
        this.emptyValue = this.prefix + this.suffix;
        return this;
    }

    public StringLinker setEmptyValue(CharSequence emptyValue) {
        this.emptyValue = Objects.requireNonNull(emptyValue, "The empty value must not be null").toString();
        return this;
    }

    public StringLinker setNullElement(CharSequence defaultElementIfNull) {
        this.defaultStringIfNull = Objects.requireNonNull(defaultElementIfNull).toString();
        return this;
    }

    private StringLinker _add(CharSequence newElement) {
        this.prepareBuilder().append(newElement == null ? null : newElement);
        return this;
    }

    public StringLinker link(Object ... newElements) {
        for (Object element : newElements) {
            this.add(element);
        }
        return this;
    }

    public StringLinker add(Object newElement) {
        return this._add(newElement == null ? this.defaultStringIfNull : Objects.toString(newElement));
    }

    public StringLinker add(CharSequence newElement, int times) {
        for (int i = 0; i < times; ++i) {
            this._add(newElement);
        }
        return this;
    }

    public StringLinker add(byte[] newElement) {
        return this._add(newElement == null ? this.defaultStringIfNull : HexUtil.BytesToHex(newElement));
    }

    public StringLinker add(int[] newElement) {
        return this._add(newElement == null ? this.defaultStringIfNull : Arrays.toString(newElement));
    }

    public StringLinker add(float[] newElement) {
        return this._add(newElement == null ? this.defaultStringIfNull : Arrays.toString(newElement));
    }

    public StringLinker add(long[] newElement) {
        return this._add(newElement == null ? this.defaultStringIfNull : Arrays.toString(newElement));
    }

    public StringLinker add(short[] newElement) {
        return this._add(newElement == null ? this.defaultStringIfNull : Arrays.toString(newElement));
    }

    public StringLinker add(double[] newElement) {
        return this._add(newElement == null ? this.defaultStringIfNull : Arrays.toString(newElement));
    }

    public StringLinker add(Object[] newElement) {
        return this._add((CharSequence)(newElement == null ? this.defaultStringIfNull : (newElement == null ? null : Objects.toString(newElement))));
    }

    public StringLinker merge(StringLinker other) {
        Objects.requireNonNull(other);
        if (other.value != null) {
            int length = other.value.length();
            StringBuilder builder = this.prepareBuilder();
            builder.append(other.value, other.prefix.length(), length);
        }
        return this;
    }

    private StringBuilder prepareBuilder() {
        if (this.value != null) {
            this.value.append(this.delimiter);
        } else {
            this.value = new StringBuilder().append(this.prefix);
        }
        return this.value;
    }

    @Override
    public int length() {
        return this.value != null ? this.value.length() + this.suffix.length() : this.emptyValue.length();
    }

    @Override
    public char charAt(int index) {
        return this.value.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.value.subSequence(start, end);
    }

    @Override
    public String toString() {
        if (this.value == null) {
            return this.prefix + this.suffix;
        }
        if (this.suffix.equals("")) {
            return this.value.toString();
        }
        int initialLength = this.value.length();
        String result = this.value.append(this.suffix).toString();
        this.value.setLength(initialLength);
        return result;
    }
}

