/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.sgeo.line.imp;

import cn.gongler.util.sgeo.gps.IGps;
import cn.gongler.util.sgeo.line.LineUpDown;
import cn.gongler.util.sgeo.line.imp.LineBusstop;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LineSide
implements Iterable<LineBusstop> {
    private static final long serialVersionUID = 5382729041582482645L;
    public static LineSide NULL = new LineSide();
    LineUpDown upDown;
    final List<LineBusstop> busstopList = new ArrayList<LineBusstop>();

    public LineSide() {
        this(LineUpDown.LINE_UP);
    }

    public LineSide(LineUpDown upDown) {
        this.upDown = upDown;
    }

    public void loadBusstops(List<LineBusstop> busstops) {
        this.busstopList.clear();
        this.busstopList.addAll(busstops);
    }

    public void appendBusstop(LineBusstop nextBusstop) {
        nextBusstop.setBusstopSerial(this.busstopList.size() + 1);
        this.busstopList.add(nextBusstop);
    }

    public LineBusstop checkNextBusstop(IGps gps, int busstopSerial, Connection conn) throws SQLException {
        int lastIndex;
        LineBusstop busstop;
        int fromIndex;
        int i;
        for (i = fromIndex = (lastIndex = this.busstopList.indexOf(last = this.getBusstopBySerial(busstopSerial))) >= 0 ? lastIndex + 1 : 0; i < this.busstopList.size(); ++i) {
            busstop = this.busstopList.get(i);
            if (!busstop.inside(gps, conn)) continue;
            return busstop;
        }
        for (i = 0; i < lastIndex; ++i) {
            busstop = this.busstopList.get(i);
            if (!busstop.inside(gps, conn)) continue;
            return busstop;
        }
        return null;
    }

    public int getBusstopCnt() {
        return this.busstopList.size();
    }

    public int getBusstopSerial(LineBusstop nextBusstop) {
        return nextBusstop.getBusstopSerial();
    }

    void clearBusstopList() {
        this.busstopList.clear();
    }

    private LineBusstop getBusstopBySerial(int busstopSerial) {
        int index = LineSide.SerialToIndex(busstopSerial);
        if (index < 0 || index >= this.busstopList.size()) {
            return null;
        }
        return this.busstopList.get(index);
    }

    public boolean isFinalBusstop(int busstopSerial) {
        return busstopSerial == this.getBusstopSerialMax();
    }

    public int getBusstopSerialMax() {
        return this.busstopList.size();
    }

    public LineUpDown upDown() {
        return this.upDown;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append("\n ").append(this.getClass().getSimpleName()).append(",").append((Object)this.upDown).append(",size=").append(this.busstopList.size()).append(",").append(this.busstopList);
        return builder.toString();
    }

    @Override
    public Iterator<LineBusstop> iterator() {
        return this.busstopList.iterator();
    }

    static int SerialToIndex(int busstopSerial) {
        int busstopIndex = busstopSerial - 1;
        return busstopIndex;
    }

    static int IndexToSerial(int busstopIndex) {
        int busstopSerial = busstopIndex - 1;
        return busstopSerial;
    }
}

