/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.sgeo.gps;

import cn.gongler.util.sgeo.gps.BusState;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BusFactory {
    private static final long serialVersionUID = 1L;
    private static BusFactory factory = null;
    private final Map<Long, BusState> busMap = new ConcurrentHashMap<Long, BusState>();

    public static BusFactory getInstance() {
        if (factory == null) {
            factory = new BusFactory();
        }
        return factory;
    }

    private BusFactory() {
    }

    public BusState getBus(long busId) {
        BusState bus = this.busMap.get(busId);
        if (bus == null) {
            bus = new BusState(busId);
            this.busMap.put(busId, bus);
        }
        return bus;
    }

    public Iterable<BusState> getIterator() {
        return this.busMap.values();
    }
}

