/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.sgeo.gps;

import cn.gongler.util.GonglerUtil;
import cn.gongler.util.sgeo.geo.Scope;
import cn.gongler.util.sgeo.geo.ScopeGroup;
import cn.gongler.util.sgeo.geo.ScopeGroupFactory;
import cn.gongler.util.sgeo.gps.IGps;
import cn.gongler.util.sgeo.line.AreaMoveAction;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class AreaEventChecker {
    private static final long serialVersionUID = 3607859424546611432L;
    private static final Map<Long, AreaEventChecker> GROUP_AREAEVENT_CHECKER_MAP = new ConcurrentSkipListMap<Long, AreaEventChecker>();
    private final long scopeGroupId;
    private final ConcurrentMap<Long, Scope> busMap = new ConcurrentSkipListMap<Long, Scope>();

    public static AreaEventChecker of(long scopeGroupId) {
        return GROUP_AREAEVENT_CHECKER_MAP.computeIfAbsent(scopeGroupId, AreaEventChecker::new);
    }

    public static AreaEventChecker CHANGZHAN() {
        return AreaEventChecker.of(3L);
    }

    public static AreaEventChecker CITY_AREA() {
        return AreaEventChecker.of(5L);
    }

    private AreaEventChecker(long scopeGroupId) {
        this.scopeGroupId = scopeGroupId;
    }

    private ScopeGroup scopeGroup() {
        return ScopeGroupFactory.of().group(this.scopeGroupId);
    }

    private Scope currentScope(long busId) {
        return (Scope)this.busMap.get(busId);
    }

    public void check(Connection conn, long busId, IGps gps) throws SQLException {
        Scope cur = this.currentScope(busId);
        ScopeGroupFactory.of();
        if (cur != null) {
            if (!cur.inside(gps)) {
                this.leaveScope(conn, busId, gps, cur);
                this.busMap.remove(busId);
            }
        } else {
            Scope enterScope = this.scopeGroup().firstInside(gps);
            if (enterScope != null) {
                this.enterNextScope(conn, busId, gps, enterScope);
                this.busMap.put(busId, enterScope);
            }
        }
    }

    private void leaveScope(Connection conn, long busId, IGps gps, Scope cur) throws SQLException {
        this.dbProc(conn, busId, gps, cur, AreaMoveAction.LEAVE);
    }

    private void enterNextScope(Connection conn, long busId, IGps gps, Scope enterScope) throws SQLException {
        this.dbProc(conn, busId, gps, enterScope, AreaMoveAction.ENTER);
    }

    private void log(Object ... items) {
        StringBuilder buf = new StringBuilder(1024);
        for (Object item : items) {
            buf.append(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dbProc(Connection conn, long busId, IGps gps, Scope scope, AreaMoveAction areaMoveAction) throws SQLException {
        this.log(new Object[]{"PK_SCOPE.SCOPE_EVENT: ", busId, ", ", gps, ", ", areaMoveAction, ", ", scope});
        CallableStatement statement = null;
        try {
            String sql = "CALL PK_SCOPE.SCOPE_EVENT (?,?,?,?,?, ?,?,?,?,?) ";
            statement = conn.prepareCall(sql);
            int pos = 1;
            statement.setTimestamp(pos++, new Timestamp(gps.gpsTime()));
            statement.setLong(pos++, scope.id());
            statement.setString(pos++, scope.name());
            statement.setLong(pos++, scope.groupId());
            statement.setInt(pos++, areaMoveAction.getValue());
            statement.setLong(pos++, busId);
            statement.setDouble(pos++, gps.gpsLng());
            statement.setDouble(pos++, gps.gpsLat());
            statement.setInt(pos++, gps.gpsAngle());
            statement.setInt(pos++, gps.gpsSpeed());
            statement.execute();
            conn.commit();
        }
        catch (Throwable throwable) {
            GonglerUtil.Close(statement);
            throw throwable;
        }
        GonglerUtil.Close(statement);
    }
}

