/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.sgeo.geo;

import cn.gongler.util.sgeo.geo.IGeoPoint;
import cn.gongler.util.sgeo.geo.XY;
import java.awt.geom.Path2D;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class Scope
implements Comparable<Scope>,
Iterable<IGeoPoint> {
    private static final long serialVersionUID = 1L;
    private final long id;
    private String name;
    private long num1;
    private long num2;
    private String str1 = "";
    private String str2 = "";
    private long groupId;
    private final Path2D.Double polygon = new Path2D.Double();
    private int pointCount = 0;
    private final List<IGeoPoint> geoPoints = new ArrayList<IGeoPoint>();
    private double area;
    private final LocalDateTime createTime = LocalDateTime.now();

    private Scope(long id) {
        this.id = id;
    }

    public long id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public long groupId() {
        return this.groupId;
    }

    public LocalDateTime createTime() {
        return this.createTime;
    }

    public boolean inside(double geoL, double geoB) {
        return this.polygon.contains(geoL, geoB);
    }

    public boolean inside(IGeoPoint gps) {
        return this.inside(gps.gpsLng(), gps.gpsLat());
    }

    public static Scope FirstInside(IGeoPoint gps, Collection<Scope> scopes) {
        for (Scope scope : scopes) {
            if (!scope.inside(gps)) continue;
            return scope;
        }
        return null;
    }

    public static List<Scope> AllInside(IGeoPoint gps, Collection<Scope> scopes) {
        return scopes.stream().filter(a -> a.inside(gps)).collect(Collectors.toList());
    }

    public int pointCount() {
        return this.pointCount;
    }

    public List<IGeoPoint> geoPoints() {
        return this.geoPoints;
    }

    public double polygonArea() {
        return this.area;
    }

    private static double TriangleArea(XY p0, XY p1, XY p2) {
        double ret = 0.5 * ((p1.x() - p0.x()) * (p2.y() - p0.y()) - (p2.x() - p0.x()) * (p1.y() - p0.y()));
        return ret;
    }

    private static double TriangleArea(IGeoPoint p1, IGeoPoint p2, IGeoPoint p3) {
        return Scope.TriangleArea(XY.of(p1), XY.of(p2), XY.of(p3));
    }

    private Scope flushPolygonArea() {
        IGeoPoint first = null;
        double areaTmp = 0.0;
        ArrayList<IGeoPoint> list = new ArrayList<IGeoPoint>(this.geoPoints);
        if (!list.isEmpty()) {
            first = (IGeoPoint)list.get(0);
            list.add(first);
        }
        for (int i = list.size() - 1; i > 0; --i) {
            IGeoPoint prev = (IGeoPoint)list.get(i - 1);
            IGeoPoint next = (IGeoPoint)list.get(i);
            areaTmp += Scope.TriangleArea(first, prev, next);
        }
        this.area = Math.abs(areaTmp);
        return this;
    }

    @Override
    public int compareTo(Scope o) {
        return Long.compare(this.id(), o.id());
    }

    public boolean equals(Object o) {
        if (o instanceof Scope) {
            Scope anather = (Scope)o;
            return Objects.equals(this.id(), anather.id());
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 47 * hash + (int)(this.id ^ this.id >>> 32);
        return hash;
    }

    @Override
    public Iterator<IGeoPoint> iterator() {
        return this.geoPoints.iterator();
    }

    public String toString() {
        return "scope" + this.id() + "," + this.name + " num1:" + this.num1 + " num2:" + this.num2 + " pnt:" + this.pointCount() + " area:" + this.polygonArea();
    }

    public long num1() {
        return this.num1;
    }

    public long num2() {
        return this.num2;
    }

    public String str1() {
        return this.str1;
    }

    public String str2() {
        return this.str2;
    }

    public static class Builder {
        private static final long serialVersionUID = 1L;
        final Scope instance;

        public Builder(long id) {
            this.instance = new Scope(id);
        }

        public Builder name(String name) {
            this.instance.name = name;
            return this;
        }

        public Builder group(long groupId) {
            this.instance.groupId = groupId;
            return this;
        }

        public Builder num1(long num1) {
            this.instance.num1 = num1;
            return this;
        }

        public Builder num2(long num2) {
            this.instance.num2 = num2;
            return this;
        }

        public Builder str1(String str1) {
            this.instance.str1 = str1;
            return this;
        }

        public Builder str2(String str2) {
            this.instance.str2 = str2;
            return this;
        }

        public Builder add(double geoL, double geoB) {
            if (this.instance.pointCount == 0) {
                this.instance.polygon.moveTo(geoL, geoB);
            } else {
                this.instance.polygon.lineTo(geoL, geoB);
            }
            this.instance.geoPoints.add(IGeoPoint.of(geoL, geoB));
            this.instance.pointCount++;
            return this;
        }

        public Builder add(IGeoPoint gps) {
            return this.add(gps.gpsLng(), gps.gpsLat());
        }

        public Builder addAll(List<IGeoPoint> points) {
            for (IGeoPoint point : points) {
                this.add(point);
            }
            return this;
        }

        public Scope build() {
            if (this.instance.pointCount > 0) {
                this.instance.polygon.closePath();
            }
            this.instance.flushPolygonArea();
            return this.instance;
        }
    }
}

