/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.sgeo.geo;

import cn.gongler.util.sgeo.geo.IGeoPoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class GeoUtil {
    private static final long serialVersionUID = -8078555444382488053L;
    private static final double EARTH_RADIUS_KM = 6371.0;
    private static final double EARTH_RADIUS_METER = 6371000.0;

    private GeoUtil() {
    }

    public static double DisMeters(IGeoPoint a, IGeoPoint b) {
        return GeoUtil.GetDistance(a.gpsLng(), a.gpsLat(), b.gpsLng(), b.gpsLat()) * 1000.0;
    }

    @Deprecated
    public static double GetDistance(IGeoPoint a, IGeoPoint b) {
        return GeoUtil.GetDistance(a.gpsLng(), a.gpsLat(), b.gpsLng(), b.gpsLat());
    }

    @Deprecated
    public static double GetDistance(double geoL1, double geoB1, double geoL2, double geoB2) {
        return GeoUtil.GetDistanceRad(Math.toRadians(geoL1), Math.toRadians(geoB1), Math.toRadians(geoL2), Math.toRadians(geoB2));
    }

    @Deprecated
    public static double GetDistanceRad(double geoL1, double geoB1, double geoL2, double geoB2) {
        double val = Math.sin(geoB1) * Math.sin(geoB2) + Math.cos(geoB1) * Math.cos(geoB2) * Math.cos(geoL1 - geoL2);
        val = Math.max(Math.min(val, 1.0), -1.0);
        double radians = Math.acos(val);
        double distance = radians * 6371.0;
        return distance;
    }

    public static List<IGeoPoint> PolygonFromCircleWith(IGeoPoint center, double radiusMeters) {
        return GeoUtil.PolygonFromCircleWith(center, radiusMeters, 12);
    }

    public static List<IGeoPoint> PolygonFromCircleWith(IGeoPoint center, double radiusMeters, int pointCnt) {
        double radiusRadian = radiusMeters / 6371000.0;
        ArrayList<IGeoPoint> list = new ArrayList<IGeoPoint>(pointCnt);
        for (int i = 0; i < pointCnt; ++i) {
            double radian = Math.PI * 2 / (double)pointCnt * (double)i;
            double geoLDeta = center.gpsLng() + Math.toDegrees(Math.sin(radian) * radiusRadian / Math.cos(Math.toRadians(center.gpsLat())));
            double geoBDeta = center.gpsLat() - Math.toDegrees(Math.cos(radian) * radiusRadian);
            IGeoPoint point = IGeoPoint.of(geoLDeta, geoBDeta);
            list.add(point);
        }
        return Collections.unmodifiableList(list);
    }
}

