/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.protocol.itemtype;

import cn.gongler.util.bytes.BytesBuilder;
import cn.gongler.util.bytes.BytesLoader;
import cn.gongler.util.protocol.itemtype.Item;
import cn.gongler.util.protocol.itemtype.StringItemType;
import java.util.Arrays;

public class StringWithLengthItemType
extends StringItemType<StringWithLengthItemType> {
    private static final long serialVersionUID = 1L;
    int bytes;
    private byte fillByte = (byte)32;

    public static StringWithLengthItemType withFixLength(int bytes, String name) {
        StringWithLengthItemType instance = new StringWithLengthItemType(bytes, name);
        return instance;
    }

    public static StringWithLengthItemType withLengthHeader(int headerBytes, String name) {
        StringWithLengthItemType instance = new StringWithLengthItemType(-headerBytes, name);
        return instance;
    }

    private StringWithLengthItemType(int bytes, String name) {
        super(name);
        this.bytes = bytes;
    }

    @Override
    public Item load(BytesLoader in) {
        int bodyLen = this.bytes < 0 ? in.loadInt(Math.abs(this.bytes)) : this.bytes;
        byte[] bodyBytes = bodyLen == 0 ? in.loadRemainBytes() : in.loadBytes(bodyLen);
        return this._newItem(this.newString(bodyBytes));
    }

    public byte fillByte() {
        return this.fillByte;
    }

    public StringWithLengthItemType fillByte(byte newValue) {
        this.fillByte = newValue;
        return this;
    }

    @Override
    public void toBytes(Object itemValue, BytesBuilder build) {
        boolean len = false;
        if (itemValue instanceof String) {
            String val = (String)itemValue;
            byte[] strBytes = val.getBytes(CHARSET);
            if (this.isFixLength()) {
                int orgLen = strBytes.length;
                byte[] fixLengthBytes = Arrays.copyOf(strBytes, this.bytes);
                if (orgLen < fixLengthBytes.length) {
                    Arrays.fill(fixLengthBytes, orgLen, fixLengthBytes.length, this.fillByte);
                }
                build.addBytes(fixLengthBytes);
            } else {
                int headLen = Math.abs(this.bytes);
                build.addNum(headLen, strBytes.length);
                build.addBytes(strBytes);
            }
        }
    }

    @Override
    public String toString() {
        return super.toString() + '_' + this.bytes;
    }

    private boolean isFixLength() {
        return this.bytes > 0;
    }
}

