/*
 * Decompiled with CFR 0.152.
 */
package cn.gongler.util.protocol.itemtype;

import cn.gongler.util.bytes.BytesBuilder;
import cn.gongler.util.bytes.BytesLoader;
import cn.gongler.util.protocol.itemtype.Item;
import cn.gongler.util.protocol.itemtype.ItemType;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Scanner;

public class StringItemType<T extends StringItemType>
extends ItemType<T> {
    private static final long serialVersionUID = 1L;
    public static final Charset CHARSET;
    public static StringItemType INSTANCE;
    private static final String DEFAULT_VAL = "\u6587\u5b57";

    public StringItemType(String name) {
        super(name);
    }

    @Override
    public Item create() {
        return this._newItem("");
    }

    @Override
    public Item load(Scanner in) {
        String val = "";
        try {
            val = in.next();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this._newItem(val);
    }

    @Override
    public Item load(BytesLoader in) {
        int b;
        int maxReabable = in.remainBytesCount();
        BytesBuilder buf = BytesBuilder.of();
        for (int i = 0; i < maxReabable && (b = in.loadUnsignedByte()) != 0; ++i) {
            buf.addByte(b);
        }
        byte[] bytes = buf.toBytes();
        return this._newItem(this.newString(bytes));
    }

    @Override
    public void toBytes(Object itemValue, BytesBuilder build) {
        if (itemValue instanceof String) {
            String val = (String)itemValue;
            build.addBytes(val.getBytes(CHARSET));
        }
        build.addByte(0);
    }

    @Override
    protected Class insideValueClass() {
        return String.class;
    }

    protected String newString(byte[] bytes) {
        return new String(StringItemType.BytesUntilZero(bytes), CHARSET);
    }

    static byte[] BytesUntilZero(byte[] src) {
        for (int i = 0; i < src.length; ++i) {
            byte b = src[i];
            if (b != 0) continue;
            return Arrays.copyOf(src, i);
        }
        return src;
    }

    @Override
    protected Item getSubitemImpl(Item item, int key) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void addSubitemImpl(Item item, Object subitemValue) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static {
        String charsetName = "GBK";
        CHARSET = Charset.isSupported(charsetName) ? Charset.forName(charsetName) : Charset.defaultCharset();
        INSTANCE = new StringItemType("STRING");
    }
}

